Liferay.Loader.define('document-library-video$lodash-es@4.17.15/_baseInverter', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import baseForOwn from './_baseForOwn.js';

    /**
     * The base implementation of `_.invert` and `_.invertBy` which inverts
     * `object` with values transformed by `iteratee` and set by `setter`.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} setter The function to set `accumulator` values.
     * @param {Function} iteratee The iteratee to transform values.
     * @param {Object} accumulator The initial inverted object.
     * @returns {Function} Returns `accumulator`.
     */
    function baseInverter(object, setter, iteratee, accumulator) {
      baseForOwn(object, function (value, key, object) {
        setter(accumulator, iteratee(value), key, object);
      });
      return accumulator;
    }

    export default baseInverter;
  }
});
//# sourceMappingURL=_baseInverter.js.map