Liferay.Loader.define('document-library-video$lodash-es@4.17.15/_getTag', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import DataView from './_DataView.js';
        import Map from './_Map.js';
        import Promise from './_Promise.js';
        import Set from './_Set.js';
        import WeakMap from './_WeakMap.js';
        import baseGetTag from './_baseGetTag.js';
        import toSource from './_toSource.js';

        /** `Object#toString` result references. */
        var mapTag = '[object Map]',
            objectTag = '[object Object]',
            promiseTag = '[object Promise]',
            setTag = '[object Set]',
            weakMapTag = '[object WeakMap]';

        var dataViewTag = '[object DataView]';

        /** Used to detect maps, sets, and weakmaps. */
        var dataViewCtorString = toSource(DataView),
            mapCtorString = toSource(Map),
            promiseCtorString = toSource(Promise),
            setCtorString = toSource(Set),
            weakMapCtorString = toSource(WeakMap);

        /**
         * Gets the `toStringTag` of `value`.
         *
         * @private
         * @param {*} value The value to query.
         * @returns {string} Returns the `toStringTag`.
         */
        var getTag = baseGetTag;

        // Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
        if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map && getTag(new Map()) != mapTag || Promise && getTag(Promise.resolve()) != promiseTag || Set && getTag(new Set()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
            getTag = function (value) {
                var result = baseGetTag(value),
                    Ctor = result == objectTag ? value.constructor : undefined,
                    ctorString = Ctor ? toSource(Ctor) : '';

                if (ctorString) {
                    switch (ctorString) {
                        case dataViewCtorString:
                            return dataViewTag;
                        case mapCtorString:
                            return mapTag;
                        case promiseCtorString:
                            return promiseTag;
                        case setCtorString:
                            return setTag;
                        case weakMapCtorString:
                            return weakMapTag;
                    }
                }
                return result;
            };
        }

        export default getTag;
    }
});
//# sourceMappingURL=_getTag.js.map