Liferay.Loader.define("document-library-web@5.0.108/document_library/js/bulk/BulkStatus.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './reducer.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reducer = _interopRequireWildcard(require("./reducer.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * Shows the bulk actions status
     */
    function BulkStatus(_ref) {
      var bulkComponentId = _ref.bulkComponentId,
          bulkInProgress = _ref.bulkInProgress,
          _ref$bulkStatusUrl = _ref.bulkStatusUrl,
          bulkStatusUrl = _ref$bulkStatusUrl === void 0 ? '/bulk/v1.0/status' : _ref$bulkStatusUrl,
          _ref$intervalSpeed = _ref.intervalSpeed,
          intervalSpeed = _ref$intervalSpeed === void 0 ? 1000 : _ref$intervalSpeed,
          pathModule = _ref.pathModule,
          _ref$waitingTime = _ref.waitingTime,
          waitingTime = _ref$waitingTime === void 0 ? 1000 : _ref$waitingTime;
      var delay = (0, _frontendJsReactWeb.useTimeout)();

      var _useReducer = (0, _react.useReducer)(_reducer.default, bulkInProgress ? {
        current: _reducer.STATES.LONG_POLLING
      } : {
        current: _reducer.STATES.IDLE
      }),
          _useReducer2 = _slicedToArray(_useReducer, 2),
          state = _useReducer2[0],
          dispatch = _useReducer2[1];

      var statusCallback = (0, _react.useCallback)(function () {
        return delay(function () {
          (0, _frontendJsWeb.fetch)("".concat(Liferay.ThemeDisplay.getPortalURL()).concat(pathModule).concat(bulkStatusUrl)).then(function (response) {
            return response.json();
          }).then(function (response) {
            if (response.actionInProgress) {
              dispatch({
                type: 'check'
              });
            } else {
              dispatch({
                type: 'success'
              });
            }
          }).catch(function () {
            return dispatch({
              type: 'error'
            });
          });
        }, intervalSpeed);
      }, [bulkStatusUrl, delay, pathModule, intervalSpeed]);
      (0, _react.useEffect)(function () {
        var dispose;

        if (state.current === _reducer.STATES.SHORT_POLLING) {
          statusCallback();
          dispose = delay(function () {
            return dispatch({
              type: 'initialDelayCompleted'
            });
          }, waitingTime);
        } else if (state.current === _reducer.STATES.LONG_POLLING) {
          statusCallback();
        } else if (state.current === _reducer.STATES.NOTIFY) {
          (0, _frontendJsWeb.openToast)(state.toast);
          dispatch({
            type: 'notificationCompleted'
          });
        }

        return dispose;
      }, [delay, state, statusCallback, waitingTime]);

      if (!Liferay.component(bulkComponentId)) {
        Liferay.component(bulkComponentId, {
          startWatch: function startWatch() {
            dispatch({
              type: 'start'
            });
          }
        }, {
          destroyOnNavigate: true
        });
      }

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "bulk-status-container"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "bulk-status ".concat(!state.current.show && 'closed')
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "bulk-status-content"
        }, /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, {
          light: true,
          small: true
        }), /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('processing-actions')))))
      );
    }

    var _default = BulkStatus;
    exports.default = _default;
    //# sourceMappingURL=BulkStatus.es.js.map
  }
});
//# sourceMappingURL=BulkStatus.es.js.map