Liferay.Loader.define("document-library-web$lodash-es@4.17.15/_matchesStrictComparable", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /**
     * A specialized version of `matchesProperty` for source values suitable
     * for strict equality comparisons, i.e. `===`.
     *
     * @private
     * @param {string} key The key of the property to get.
     * @param {*} srcValue The value to match.
     * @returns {Function} Returns the new spec function.
     */
    function matchesStrictComparable(key, srcValue) {
      return function (object) {
        if (object == null) {
          return false;
        }
        return object[key] === srcValue && (srcValue !== undefined || key in Object(object));
      };
    }

    export default matchesStrictComparable;
  }
});
//# sourceMappingURL=_matchesStrictComparable.js.map