/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.lists.constants;

/**
 * Holds generic constants used in DDL services.
 *
 * @author Marcellus Tavares
 * @author Eduardo Lundgren
 */
public class DDLConstants {

	/**
	 * {@value #RESERVED_DDM_STRUCTURE_ID} is a Reserved String and the name of
	 * the DDL Display Template variable that holds the Structure ID configured
	 * for the Record Set. The variable is injected into the DDL Display
	 * Template context.
	 */
	public static final String RESERVED_DDM_STRUCTURE_ID =
		"reserved_ddm_structure_id";

	/**
	 * {@value #RESERVED_DDM_TEMPLATE_ID} is a Reserved String and the name of
	 * the DDL Display Template variable that holds the Template ID. The
	 * variable is injected into the DDL Display Template context.
	 */
	public static final String RESERVED_DDM_TEMPLATE_ID =
		"reserved_ddm_template_id";

	/**
	 * {@value #RESERVED_RECORD_SET_DESCRIPTION} is a Reserved String and the
	 * name of the DDL Display Template variable that holds the Record Set
	 * description. The variable is injected into the DDL Display Template
	 * context.
	 */
	public static final String RESERVED_RECORD_SET_DESCRIPTION =
		"reserved_record_set_description";

	/**
	 * {@value #RESERVED_RECORD_SET_ID} is a Reserved String and the name of the
	 * DDL Display Template variable that holds the Record Set ID. The variable
	 * is injected into the DDL Display Template context.
	 */
	public static final String RESERVED_RECORD_SET_ID =
		"reserved_record_set_id";

	/**
	 * {@value #RESERVED_RECORD_SET_NAME} is a Reserved String and the name of
	 * the DDL Display Template variable that holds the Record Set name. The
	 * variable is injected into the DDL Display Template context.
	 */
	public static final String RESERVED_RECORD_SET_NAME =
		"reserved_record_set_name";

	public static final String RESOURCE_NAME = "com.liferay.dynamic.data.lists";

	public static final String SERVICE_NAME = "com.liferay.dynamic.data.lists";

}