/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.lar;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetSettings;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class DDLRecordSetStagedModelDataHandler
extends BaseStagedModelDataHandler<DDLRecordSet> {
    public static final String[] CLASS_NAMES = new String[]{DDLRecordSet.class.getName()};
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;

    public void deleteStagedModel(DDLRecordSet recordSet) throws PortalException {
        this._ddlRecordSetLocalService.deleteRecordSet(recordSet);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDLRecordSet ddlRecordSet = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddlRecordSet != null) {
            this.deleteStagedModel(ddlRecordSet);
        }
    }

    public DDLRecordSet fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddlRecordSetLocalService.fetchDDLRecordSetByUuidAndGroupId(uuid, groupId);
    }

    public List<DDLRecordSet> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddlRecordSetLocalService.getDDLRecordSetsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDLRecordSet recordSet) {
        return recordSet.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)recordSet, (StagedModel)ddmStructure, (String)"strong");
        List ddmTemplates = ddmStructure.getTemplates();
        Element recordSetElement = portletDataContext.getExportDataElement((ClassedModel)recordSet);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)recordSet, (StagedModel)ddmTemplate, (String)"strong");
        }
        if (recordSet.getScope() == 2) {
            this.exportRecordSetSettings(portletDataContext, recordSet, recordSetElement);
        }
        portletDataContext.addClassedModel(recordSetElement, ExportImportPathUtil.getModelPath((StagedModel)recordSet), (ClassedModel)recordSet);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long recordSetId) throws Exception {
        DDLRecordSet existingRecordSet = (DDLRecordSet)this.fetchMissingReference(uuid, groupId);
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        recordSetIds.put(recordSetId, existingRecordSet.getRecordSetId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        long userId = portletDataContext.getUserId(recordSet.getUserUuid());
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long ddmStructureId = MapUtil.getLong((Map)ddmStructureIds, (long)recordSet.getDDMStructureId(), (long)recordSet.getDDMStructureId());
        Element recordSetElement = portletDataContext.getImportDataElement((StagedModel)recordSet);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)recordSet);
        DDLRecordSet importedRecordSet = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDLRecordSet existingRecordSet = this.fetchStagedModelByUuidAndGroupId(recordSet.getUuid(), portletDataContext.getScopeGroupId());
            if (existingRecordSet == null) {
                serviceContext.setUuid(recordSet.getUuid());
                importedRecordSet = this._ddlRecordSetLocalService.addRecordSet(userId, portletDataContext.getScopeGroupId(), ddmStructureId, recordSet.getRecordSetKey(), recordSet.getNameMap(), recordSet.getDescriptionMap(), recordSet.getMinDisplayRows(), recordSet.getScope(), serviceContext);
            } else {
                importedRecordSet = this._ddlRecordSetLocalService.updateRecordSet(existingRecordSet.getRecordSetId(), ddmStructureId, recordSet.getNameMap(), recordSet.getDescriptionMap(), recordSet.getMinDisplayRows(), serviceContext);
            }
        } else {
            importedRecordSet = this._ddlRecordSetLocalService.addRecordSet(userId, portletDataContext.getScopeGroupId(), ddmStructureId, recordSet.getRecordSetKey(), recordSet.getNameMap(), recordSet.getDescriptionMap(), recordSet.getMinDisplayRows(), recordSet.getScope(), serviceContext);
        }
        if (recordSet.getScope() == 2) {
            DDMFormValues settingsDDMFormValues = this.getImportRecordSetSettings(portletDataContext, recordSetElement);
            this._ddlRecordSetLocalService.updateRecordSet(importedRecordSet.getRecordSetId(), settingsDDMFormValues);
        }
        portletDataContext.importClassedModel((ClassedModel)recordSet, (ClassedModel)importedRecordSet);
    }

    protected void exportRecordSetSettings(PortletDataContext portletDataContext, DDLRecordSet recordSet, Element recordSetElement) {
        String settingsDDMFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)recordSet, (String)"settings-ddm-form-values.json");
        recordSetElement.addAttribute("settings-ddm-form-values-path", settingsDDMFormValuesPath);
        portletDataContext.addZipEntry(settingsDDMFormValuesPath, recordSet.getSettings());
    }

    protected DDMFormValues getImportRecordSetSettings(PortletDataContext portletDataContext, Element recordSetElement) throws Exception {
        DDMForm ddmForm = DDMFormFactory.create(DDLRecordSetSettings.class);
        String settingsDDMFormValuesPath = recordSetElement.attributeValue("settings-ddm-form-values-path");
        String serializedSettingsDDMFormValues = portletDataContext.getZipEntryAsString(settingsDDMFormValuesPath);
        return this._ddmFormValuesJSONDeserializer.deserialize(ddmForm, serializedSettingsDDMFormValues);
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }
}

