/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.search;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordVersionLocalService;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordPermission;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class DDLRecordIndexer
extends BaseIndexer<DDLRecord> {
    public static final String CLASS_NAME = DDLRecord.class.getName();
    private static final int[] _REINDEX_SCOPES = new int[]{0, 2};
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordIndexer.class);
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private DDLRecordVersionLocalService _ddlRecordVersionLocalService;
    private DDMIndexer _ddmIndexer;
    private StorageEngine _storageEngine;

    public DDLRecordIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"description", "title"});
        this.setFilterSearch(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return DDLRecordPermission.contains(permissionChecker, entryClassPK, actionId);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long recordSetId;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextBooleanFilter.addRequiredTerm("status", status);
        }
        if ((recordSetId = GetterUtil.getLong((Object)searchContext.getAttribute("recordSetId"))) > 0L) {
            contextBooleanFilter.addRequiredTerm("recordSetId", recordSetId);
        }
        this.addSearchClassTypeIds(contextBooleanFilter, searchContext);
        String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            QueryFilter queryFilter = this._ddmIndexer.createFieldValueQueryFilter(ddmStructureFieldName, ddmStructureFieldValue, searchContext.getLocale());
            contextBooleanFilter.add((Filter)queryFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchTerm(searchQuery, searchContext, "ddmContent", false);
    }

    protected void doDelete(DDLRecord ddlRecord) throws Exception {
        this.deleteDocument(ddlRecord.getCompanyId(), ddlRecord.getRecordId());
    }

    protected Document doGetDocument(DDLRecord ddlRecord) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)ddlRecord);
        DDLRecordVersion recordVersion = ddlRecord.getRecordVersion();
        document.addKeyword("classTypeId", recordVersion.getRecordSetId());
        document.addKeyword("status", recordVersion.getStatus());
        document.addKeyword("version", recordVersion.getVersion());
        document.addText("ddmContent", this.extractDDMContent(recordVersion, LocaleUtil.getSiteDefault()));
        document.addKeyword("recordSetId", recordVersion.getRecordSetId());
        DDLRecordSet recordSet = recordVersion.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
        this._ddmIndexer.addAttributes(document, ddmStructure, ddmFormValues);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        long recordSetId = GetterUtil.getLong((String)document.get("recordSetId"));
        String title = this.getTitle(recordSetId, locale);
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        summary.setTitle(title);
        return summary;
    }

    protected void doReindex(DDLRecord ddlRecord) throws Exception {
        DDLRecordVersion recordVersion = ddlRecord.getRecordVersion();
        Document document = this.getDocument(ddlRecord);
        if (!recordVersion.isApproved()) {
            if (Validator.equals((Object)recordVersion.getVersion(), (Object)"1.0")) {
                IndexWriterHelperUtil.deleteDocument((String)this.getSearchEngineId(), (long)ddlRecord.getCompanyId(), (String)document.get("uid"), (boolean)this.isCommitImmediately());
            }
            return;
        }
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)ddlRecord.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DDLRecord record = this._ddlRecordLocalService.getRecord(classPK);
        this.doReindex(record);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexRecords(companyId);
    }

    protected String extractDDMContent(DDLRecordVersion recordVersion, Locale locale) throws Exception {
        DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
        if (ddmFormValues == null) {
            return "";
        }
        DDLRecordSet recordSet = recordVersion.getRecordSet();
        return this._ddmIndexer.extractIndexableAttributes(recordSet.getDDMStructure(), ddmFormValues, locale);
    }

    protected String getTitle(long recordSetId, Locale locale) {
        try {
            DDLRecordSet recordSet = this._ddlRecordSetLocalService.getRecordSet(recordSetId);
            DDMStructure ddmStructure = recordSet.getDDMStructure();
            String ddmStructureName = ddmStructure.getName(locale);
            String recordSetName = recordSet.getName(locale);
            return LanguageUtil.format((Locale)locale, (String)"new-x-for-list-x", (Object[])new Object[]{ddmStructureName, recordSetName}, (boolean)false);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return "";
        }
    }

    protected void reindexRecords(long companyId) throws Exception {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._ddlRecordLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property recordIdProperty = PropertyFactoryUtil.forName((String)"recordId");
                DynamicQuery recordVersionDynamicQuery = DDLRecordIndexer.this._ddlRecordVersionLocalService.dynamicQuery();
                recordVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"recordId"));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                recordVersionDynamicQuery.add(statusProperty.eq((Object)0));
                dynamicQuery.add(recordIdProperty.in(recordVersionDynamicQuery));
                Property recordSetProperty = PropertyFactoryUtil.forName((String)"recordSetId");
                DynamicQuery recordSetDynamicQuery = DDLRecordIndexer.this._ddlRecordSetLocalService.dynamicQuery();
                recordSetDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"recordSetId"));
                Property scopeProperty = PropertyFactoryUtil.forName((String)"scope");
                recordSetDynamicQuery.add(scopeProperty.in(_REINDEX_SCOPES));
                dynamicQuery.add(recordSetProperty.in(recordSetDynamicQuery));
            }
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DDLRecord>(){

            public void performAction(DDLRecord record) throws PortalException {
                block3: {
                    try {
                        Document document = DDLRecordIndexer.this.getDocument(record);
                        if (document != null) {
                            indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                        }
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to index dynamic data lists record " + record.getRecordId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordVersionLocalService(DDLRecordVersionLocalService ddlRecordVersionLocalService) {
        this._ddlRecordVersionLocalService = ddlRecordVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMIndexer(DDMIndexer ddmIndexer) {
        this._ddmIndexer = ddmIndexer;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }
}

