/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.service.base.DDLRecordServiceBaseImpl;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordPermission;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordSetPermission;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;

public class DDLRecordServiceImpl
extends DDLRecordServiceBaseImpl {
    public DDLRecord addRecord(long groupId, long recordSetId, int displayIndex, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "ADD_RECORD");
        return this.ddlRecordLocalService.addRecord(this.getGuestOrUserId(), groupId, recordSetId, displayIndex, ddmFormValues, serviceContext);
    }

    public DDLRecord addRecord(long groupId, long recordSetId, int displayIndex, Fields fields, ServiceContext serviceContext) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "ADD_RECORD");
        return this.ddlRecordLocalService.addRecord(this.getGuestOrUserId(), groupId, recordSetId, displayIndex, fields, serviceContext);
    }

    public DDLRecord addRecord(long groupId, long recordSetId, int displayIndex, Map<String, Serializable> fieldsMap, ServiceContext serviceContext) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "ADD_RECORD");
        return this.ddlRecordLocalService.addRecord(this.getGuestOrUserId(), groupId, recordSetId, displayIndex, fieldsMap, serviceContext);
    }

    public void deleteRecord(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordPermission.check(this.getPermissionChecker(), record.getRecordId(), "DELETE");
        this.ddlRecordLocalService.deleteRecord(record);
    }

    public DDLRecord deleteRecordLocale(long recordId, Locale locale, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordPermission.check(this.getPermissionChecker(), record.getRecordId(), "UPDATE");
        return this.ddlRecordLocalService.deleteRecordLocale(recordId, locale, serviceContext);
    }

    public DDLRecord getRecord(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordPermission.check(this.getPermissionChecker(), record.getRecordId(), "VIEW");
        return record;
    }

    public void revertRecord(long recordId, String version, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordPermission.check(this.getPermissionChecker(), record.getRecordId(), "UPDATE");
        this.ddlRecordLocalService.revertRecord(this.getGuestOrUserId(), recordId, version, serviceContext);
    }

    @Deprecated
    public void revertRecordVersion(long recordId, String version, ServiceContext serviceContext) throws PortalException {
        this.revertRecord(recordId, version, serviceContext);
    }

    public DDLRecord updateRecord(long recordId, boolean majorVersion, int displayIndex, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordPermission.check(this.getPermissionChecker(), record.getRecordId(), "UPDATE");
        return this.ddlRecordLocalService.updateRecord(this.getUserId(), recordId, majorVersion, displayIndex, ddmFormValues, serviceContext);
    }

    public DDLRecord updateRecord(long recordId, boolean majorVersion, int displayIndex, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordPermission.check(this.getPermissionChecker(), record.getRecordId(), "UPDATE");
        return this.ddlRecordLocalService.updateRecord(this.getUserId(), recordId, majorVersion, displayIndex, fields, mergeFields, serviceContext);
    }

    public DDLRecord updateRecord(long recordId, int displayIndex, Map<String, Serializable> fieldsMap, boolean mergeFields, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordPermission.check(this.getPermissionChecker(), record.getRecordId(), "UPDATE");
        return this.ddlRecordLocalService.updateRecord(this.getUserId(), recordId, displayIndex, fieldsMap, mergeFields, serviceContext);
    }
}

