/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.base.DDLRecordVersionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddl", "json.web.service.context.path=DDLRecordVersion"}, service={AopService.class})
public class DDLRecordVersionServiceImpl
extends DDLRecordVersionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dynamic.data.lists.model.DDLRecordSet)")
    private ModelResourcePermission<DDLRecordSet> _ddlRecordSetModelResourcePermission;

    public DDLRecordVersion getRecordVersion(long recordVersionId) throws PortalException {
        DDLRecordVersion recordVersion = this.ddlRecordVersionLocalService.getRecordVersion(recordVersionId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordVersion.getRecordSetId(), "VIEW");
        return recordVersion;
    }

    public DDLRecordVersion getRecordVersion(long recordId, String version) throws PortalException {
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.findByR_V(recordId, version);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordVersion.getRecordSetId(), "VIEW");
        return recordVersion;
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "VIEW");
        return this.ddlRecordVersionPersistence.findByRecordId(recordId);
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "VIEW");
        return this.ddlRecordVersionPersistence.findByRecordId(recordId, start, end, orderByComparator);
    }

    public int getRecordVersionsCount(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "VIEW");
        return this.ddlRecordVersionPersistence.countByRecordId(recordId);
    }
}

