/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.internal.exporter.BaseDDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistry;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDLExporter.class})
public class DDLXMLExporter
extends BaseDDLExporter {
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordSetService _ddlRecordSetService;
    private DDLRecordSetVersionService _ddlRecordSetVersionService;
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private DDMFormFieldValueRendererRegistry _ddmFormFieldValueRendererRegistry;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;
    private StorageEngine _storageEngine;

    public String getFormat() {
        return "xml";
    }

    @Override
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        Map<String, DDMFormField> ddmFormFields = this.getDistinctFields(recordSetId);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        List records = this._ddlRecordLocalService.getRecords(recordSetId, status, start, end, orderByComparator);
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        for (DDLRecord record : records) {
            Element fieldsElement = rootElement.addElement("fields");
            DDLRecordVersion recordVersion = record.getRecordVersion();
            Map<String, BaseDDLExporter.DDMFormFieldRenderedValue> values = this.getRenderedValues(recordSet.getScope(), ddmFormFields.values(), this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId()), this._htmlParser);
            for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
                BaseDDLExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue = values.get(entry.getKey());
                this._addFieldElement(ddmFormFieldRenderedValue, fieldsElement, entry);
            }
            Locale locale = this.getLocale();
            this._addFieldElement(fieldsElement, this._language.get(locale, "status"), (Serializable)((Object)this.getStatusMessage(recordVersion.getStatus())));
            this._addFieldElement(fieldsElement, this._language.get(locale, "modified-date"), (Serializable)((Object)this.formatDate(recordVersion.getStatusDate(), dateTimeFormatter)));
            this._addFieldElement(fieldsElement, this._language.get(locale, "author"), (Serializable)((Object)recordVersion.getUserName()));
        }
        String xml = document.asXML();
        return xml.getBytes();
    }

    @Override
    protected DDLRecordSetVersionService getDDLRecordSetVersionService() {
        return this._ddlRecordSetVersionService;
    }

    @Override
    protected DDMFormFieldTypeServicesTracker getDDMFormFieldTypeServicesTracker() {
        return this._ddmFormFieldTypeServicesTracker;
    }

    @Override
    protected DDMFormFieldValueRendererRegistry getDDMFormFieldValueRendererRegistry() {
        return this._ddmFormFieldValueRendererRegistry;
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetVersionService(DDLRecordSetVersionService ddlRecordSetVersionService) {
        this._ddlRecordSetVersionService = ddlRecordSetVersionService;
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldValueRendererRegistry(DDMFormFieldValueRendererRegistry ddmFormFieldValueRendererRegistry) {
        this._ddmFormFieldValueRendererRegistry = ddmFormFieldValueRendererRegistry;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }

    private void _addFieldElement(BaseDDLExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue, Element element, Map.Entry<String, DDMFormField> entry) {
        LocalizedValue label = null;
        String value = null;
        if (ddmFormFieldRenderedValue == null) {
            DDMFormField ddmFormField = entry.getValue();
            label = ddmFormField.getLabel();
            value = "";
        } else {
            label = ddmFormFieldRenderedValue.getLabel();
            value = ddmFormFieldRenderedValue.getValue();
        }
        this._addFieldElement(element, label.getString(this.getLocale()), (Serializable)((Object)value));
    }

    private void _addFieldElement(Element fieldsElement, String label, Serializable value) {
        Element fieldElement = fieldsElement.addElement("field");
        Element labelElement = fieldElement.addElement("label");
        labelElement.addText(label);
        Element valueElement = fieldElement.addElement("value");
        valueElement.addText(String.valueOf(value));
    }
}

