/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model;

import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMFormFieldOptions
implements Serializable {
    private Locale _defaultLocale;
    private final Map<String, LocalizedValue> _options = new LinkedHashMap<String, LocalizedValue>();
    private final Map<String, String> _optionsReferences = new LinkedHashMap<String, String>();

    public DDMFormFieldOptions() {
        this(LocaleUtil.getDefault());
    }

    public DDMFormFieldOptions(DDMFormFieldOptions ddmFormFieldOptions) {
        this._defaultLocale = ddmFormFieldOptions._defaultLocale;
        Map<String, String> optionsReferences = ddmFormFieldOptions._optionsReferences;
        Map<String, LocalizedValue> options = ddmFormFieldOptions._options;
        for (Map.Entry<String, LocalizedValue> entry : options.entrySet()) {
            LocalizedValue localizedValue = entry.getValue();
            String optionValue = entry.getKey();
            for (Locale locale : localizedValue.getAvailableLocales()) {
                this.addOptionLabel(optionValue, locale, localizedValue.getString(locale));
            }
            this.addOptionReference(optionValue, optionsReferences.get(optionValue));
        }
    }

    public DDMFormFieldOptions(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
    }

    public void addOption(String value) {
        this._options.put(value, new LocalizedValue(this._defaultLocale));
    }

    public void addOptionLabel(String optionValue, Locale locale, String label) {
        LocalizedValue labels = this._options.get(optionValue);
        if (labels == null) {
            labels = new LocalizedValue(this._defaultLocale);
            this._options.put(optionValue, labels);
        }
        labels.addString(locale, label);
    }

    public void addOptionReference(String optionValue, String optionReference) {
        this._optionsReferences.put(optionValue, optionReference);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DDMFormFieldOptions)) {
            return false;
        }
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)object;
        return Objects.equals(this._defaultLocale, ddmFormFieldOptions._defaultLocale) && Objects.equals(this._options, ddmFormFieldOptions._options);
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public LocalizedValue getOptionLabels(String optionValue) {
        return this._options.get(optionValue);
    }

    public String getOptionReference(String optionValue) {
        return this._optionsReferences.get(optionValue);
    }

    public Map<String, LocalizedValue> getOptions() {
        return this._options;
    }

    public Map<String, String> getOptionsReferences() {
        return this._optionsReferences;
    }

    public Set<String> getOptionsValues() {
        return this._options.keySet();
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)this._defaultLocale);
        return HashUtil.hash((int)hash, this._options);
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
        for (LocalizedValue localizedValue : this._options.values()) {
            localizedValue.setDefaultLocale(defaultLocale);
        }
    }
}

