/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DDMFormValuesConverterUtil {
    public static List<DDMFormFieldValue> addMissingDDMFormFieldValues(Collection<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValues) {
        ArrayList<DDMFormFieldValue> newDDMFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            final String ddmFormFieldName = ddmFormField.getName();
            if (ddmFormFieldValues.containsKey(ddmFormFieldName)) {
                newDDMFormFieldValues.addAll((Collection<DDMFormFieldValue>)ddmFormFieldValues.get(ddmFormFieldName));
            } else {
                newDDMFormFieldValues.add(new DDMFormFieldValue(){
                    {
                        this.setInstanceId(StringUtil.randomString());
                        this.setName(ddmFormFieldName);
                    }
                });
            }
            if (!StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) continue;
            for (DDMFormFieldValue newDDMFormFieldValue : newDDMFormFieldValues) {
                if (!StringUtil.equals((String)newDDMFormFieldValue.getName(), (String)ddmFormFieldName)) continue;
                DDMFormValuesConverterUtil._addMissingNestedDDMFormFieldValues(newDDMFormFieldValue, DDMFormValuesConverterUtil.addMissingDDMFormFieldValues(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues));
                DDMFormValuesConverterUtil._removeExtraNestedDDMFormFieldValues(newDDMFormFieldValue, ddmFormField.getNestedDDMFormFields());
            }
        }
        return newDDMFormFieldValues;
    }

    private static void _addMissingNestedDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue, List<DDMFormFieldValue> nestedDDMFormFieldValues) {
        Set<String> nestedDDMFormFieldNames = DDMFormValuesConverterUtil._getDDMFormFieldNames(ddmFormFieldValue.getNestedDDMFormFieldValues());
        for (DDMFormFieldValue nestedDDMFormFieldValue : nestedDDMFormFieldValues) {
            if (nestedDDMFormFieldNames.contains(nestedDDMFormFieldValue.getName())) continue;
            ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
        }
    }

    private static Set<String> _getDDMFormFieldNames(List<DDMFormFieldValue> ddmFormFieldValues) {
        if (ListUtil.isEmpty(ddmFormFieldValues)) {
            return Collections.emptySet();
        }
        Stream stream = ddmFormFieldValues.stream();
        return stream.map(DDMFormFieldValue::getName).collect(Collectors.toSet());
    }

    private static void _removeExtraNestedDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue, List<DDMFormField> nestedDDMFormFields) {
        Map<String, List<DDMFormFieldValue>> nestedDDMFormFieldValuesMap = ddmFormFieldValue.getNestedDDMFormFieldValuesMap();
        ddmFormFieldValue.setNestedDDMFormFields(new ArrayList<DDMFormFieldValue>());
        Stream stream = nestedDDMFormFields.stream();
        stream.map(DDMFormField::getName).map(nestedDDMFormFieldValuesMap::get).flatMap(Collection::stream).forEach(nestedDDMFormFieldValue -> ddmFormFieldValue.addNestedDDMFormFieldValue((DDMFormFieldValue)nestedDDMFormFieldValue));
    }
}

