/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.TypedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the DDMStructureLayout service. Represents a row in the &quot;DDMStructureLayout&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.dynamic.data.mapping.model.impl.DDMStructureLayoutModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.dynamic.data.mapping.model.impl.DDMStructureLayoutImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMStructureLayout
 * @generated
 */
@ProviderType
public interface DDMStructureLayoutModel
	extends BaseModel<DDMStructureLayout>, CTModel<DDMStructureLayout>,
			GroupedModel, LocalizedModel, MVCCModel, ShardedModel,
			StagedAuditedModel, TypedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a ddm structure layout model instance should use the {@link DDMStructureLayout} interface instead.
	 */

	/**
	 * Returns the primary key of this ddm structure layout.
	 *
	 * @return the primary key of this ddm structure layout
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this ddm structure layout.
	 *
	 * @param primaryKey the primary key of this ddm structure layout
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this ddm structure layout.
	 *
	 * @return the mvcc version of this ddm structure layout
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this ddm structure layout.
	 *
	 * @param mvccVersion the mvcc version of this ddm structure layout
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this ddm structure layout.
	 *
	 * @return the ct collection ID of this ddm structure layout
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this ddm structure layout.
	 *
	 * @param ctCollectionId the ct collection ID of this ddm structure layout
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this ddm structure layout.
	 *
	 * @return the uuid of this ddm structure layout
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this ddm structure layout.
	 *
	 * @param uuid the uuid of this ddm structure layout
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the structure layout ID of this ddm structure layout.
	 *
	 * @return the structure layout ID of this ddm structure layout
	 */
	public long getStructureLayoutId();

	/**
	 * Sets the structure layout ID of this ddm structure layout.
	 *
	 * @param structureLayoutId the structure layout ID of this ddm structure layout
	 */
	public void setStructureLayoutId(long structureLayoutId);

	/**
	 * Returns the group ID of this ddm structure layout.
	 *
	 * @return the group ID of this ddm structure layout
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this ddm structure layout.
	 *
	 * @param groupId the group ID of this ddm structure layout
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this ddm structure layout.
	 *
	 * @return the company ID of this ddm structure layout
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this ddm structure layout.
	 *
	 * @param companyId the company ID of this ddm structure layout
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this ddm structure layout.
	 *
	 * @return the user ID of this ddm structure layout
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this ddm structure layout.
	 *
	 * @param userId the user ID of this ddm structure layout
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this ddm structure layout.
	 *
	 * @return the user uuid of this ddm structure layout
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this ddm structure layout.
	 *
	 * @param userUuid the user uuid of this ddm structure layout
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this ddm structure layout.
	 *
	 * @return the user name of this ddm structure layout
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this ddm structure layout.
	 *
	 * @param userName the user name of this ddm structure layout
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this ddm structure layout.
	 *
	 * @return the create date of this ddm structure layout
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this ddm structure layout.
	 *
	 * @param createDate the create date of this ddm structure layout
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this ddm structure layout.
	 *
	 * @return the modified date of this ddm structure layout
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this ddm structure layout.
	 *
	 * @param modifiedDate the modified date of this ddm structure layout
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the fully qualified class name of this ddm structure layout.
	 *
	 * @return the fully qualified class name of this ddm structure layout
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this ddm structure layout.
	 *
	 * @return the class name ID of this ddm structure layout
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this ddm structure layout.
	 *
	 * @param classNameId the class name ID of this ddm structure layout
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the structure layout key of this ddm structure layout.
	 *
	 * @return the structure layout key of this ddm structure layout
	 */
	public String getStructureLayoutKey();

	/**
	 * Sets the structure layout key of this ddm structure layout.
	 *
	 * @param structureLayoutKey the structure layout key of this ddm structure layout
	 */
	public void setStructureLayoutKey(String structureLayoutKey);

	/**
	 * Returns the structure version ID of this ddm structure layout.
	 *
	 * @return the structure version ID of this ddm structure layout
	 */
	public long getStructureVersionId();

	/**
	 * Sets the structure version ID of this ddm structure layout.
	 *
	 * @param structureVersionId the structure version ID of this ddm structure layout
	 */
	public void setStructureVersionId(long structureVersionId);

	/**
	 * Returns the name of this ddm structure layout.
	 *
	 * @return the name of this ddm structure layout
	 */
	public String getName();

	/**
	 * Returns the localized name of this ddm structure layout in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this ddm structure layout
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this ddm structure layout in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this ddm structure layout. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this ddm structure layout in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this ddm structure layout
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this ddm structure layout in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this ddm structure layout
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this ddm structure layout.
	 *
	 * @return the locales and localized names of this ddm structure layout
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this ddm structure layout.
	 *
	 * @param name the name of this ddm structure layout
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this ddm structure layout in the language.
	 *
	 * @param name the localized name of this ddm structure layout
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this ddm structure layout in the language, and sets the default locale.
	 *
	 * @param name the localized name of this ddm structure layout
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this ddm structure layout from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this ddm structure layout
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this ddm structure layout from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this ddm structure layout
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	/**
	 * Returns the description of this ddm structure layout.
	 *
	 * @return the description of this ddm structure layout
	 */
	public String getDescription();

	/**
	 * Returns the localized description of this ddm structure layout in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized description of this ddm structure layout
	 */
	@AutoEscape
	public String getDescription(Locale locale);

	/**
	 * Returns the localized description of this ddm structure layout in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized description of this ddm structure layout. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getDescription(Locale locale, boolean useDefault);

	/**
	 * Returns the localized description of this ddm structure layout in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized description of this ddm structure layout
	 */
	@AutoEscape
	public String getDescription(String languageId);

	/**
	 * Returns the localized description of this ddm structure layout in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized description of this ddm structure layout
	 */
	@AutoEscape
	public String getDescription(String languageId, boolean useDefault);

	@AutoEscape
	public String getDescriptionCurrentLanguageId();

	@AutoEscape
	public String getDescriptionCurrentValue();

	/**
	 * Returns a map of the locales and localized descriptions of this ddm structure layout.
	 *
	 * @return the locales and localized descriptions of this ddm structure layout
	 */
	public Map<Locale, String> getDescriptionMap();

	/**
	 * Sets the description of this ddm structure layout.
	 *
	 * @param description the description of this ddm structure layout
	 */
	public void setDescription(String description);

	/**
	 * Sets the localized description of this ddm structure layout in the language.
	 *
	 * @param description the localized description of this ddm structure layout
	 * @param locale the locale of the language
	 */
	public void setDescription(String description, Locale locale);

	/**
	 * Sets the localized description of this ddm structure layout in the language, and sets the default locale.
	 *
	 * @param description the localized description of this ddm structure layout
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setDescription(
		String description, Locale locale, Locale defaultLocale);

	public void setDescriptionCurrentLanguageId(String languageId);

	/**
	 * Sets the localized descriptions of this ddm structure layout from the map of locales and localized descriptions.
	 *
	 * @param descriptionMap the locales and localized descriptions of this ddm structure layout
	 */
	public void setDescriptionMap(Map<Locale, String> descriptionMap);

	/**
	 * Sets the localized descriptions of this ddm structure layout from the map of locales and localized descriptions, and sets the default locale.
	 *
	 * @param descriptionMap the locales and localized descriptions of this ddm structure layout
	 * @param defaultLocale the default locale
	 */
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale);

	/**
	 * Returns the definition of this ddm structure layout.
	 *
	 * @return the definition of this ddm structure layout
	 */
	@AutoEscape
	public String getDefinition();

	/**
	 * Sets the definition of this ddm structure layout.
	 *
	 * @param definition the definition of this ddm structure layout
	 */
	public void setDefinition(String definition);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public DDMStructureLayout cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}