/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage;

import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Fields
implements Iterable<Field>,
Serializable {
    private final Map<String, Field> _fieldsMap = new HashMap<String, Field>();

    public boolean contains(String name) {
        return this._fieldsMap.containsKey(name);
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean includePrivateFields) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Fields)) {
            return false;
        }
        Fields fields = (Fields)object;
        if (includePrivateFields) {
            return Objects.equals(this._fieldsMap, fields._fieldsMap);
        }
        List<Field> fieldsList1 = this.getFieldsList(includePrivateFields);
        List<Field> fieldsList2 = fields.getFieldsList(includePrivateFields);
        if (fieldsList1.size() != fieldsList2.size()) {
            return false;
        }
        return fieldsList1.containsAll(fieldsList2);
    }

    public Field get(String name) {
        return this._fieldsMap.get(name);
    }

    public Set<Locale> getAvailableLocales() {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (Field field : this._fieldsMap.values()) {
            if (field.isPrivate()) continue;
            for (Locale availableLocale : field.getAvailableLocales()) {
                availableLocales.add(availableLocale);
            }
        }
        return availableLocales;
    }

    public long getDDMStructureId() {
        long ddmStructureId = 0L;
        Iterator<Field> iterator = this.iterator();
        if (iterator.hasNext()) {
            Field field = iterator.next();
            ddmStructureId = field.getDDMStructureId();
        }
        return ddmStructureId;
    }

    public Locale getDefaultLocale() {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        Iterator<Field> iterator = this.iterator();
        if (iterator.hasNext()) {
            Field field = iterator.next();
            defaultLocale = field.getDefaultLocale();
        }
        return defaultLocale;
    }

    public Set<String> getNames() {
        return this._fieldsMap.keySet();
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._fieldsMap);
        return HashUtil.hash((int)hash, this.getFieldsList(true));
    }

    @Override
    public Iterator<Field> iterator() {
        return this.iterator(false);
    }

    public Iterator<Field> iterator(boolean includePrivateFields) {
        return this.iterator(null, includePrivateFields);
    }

    public Iterator<Field> iterator(Comparator<Field> comparator, boolean includePrivateFields) {
        List<Field> fieldsList = this.getFieldsList(includePrivateFields);
        if (comparator != null) {
            Collections.sort(fieldsList, comparator);
        }
        return fieldsList.iterator();
    }

    public void put(Field field) {
        this._fieldsMap.put(field.getName(), field);
    }

    public Field remove(String name) {
        return this._fieldsMap.remove(name);
    }

    protected List<Field> getFieldsList(boolean includePrivateFields) {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Field field : this._fieldsMap.values()) {
            if (!includePrivateFields && field.isPrivate()) continue;
            fieldsList.add(field);
        }
        return fieldsList;
    }
}

