/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Stream;

public class DDMFormReportDataUtil {
    public static JSONArray getFieldsJSONArray(DDMFormInstanceReport ddmFormInstanceReport) throws PortalException {
        JSONArray fieldsJSONArray = JSONFactoryUtil.createJSONArray();
        if (ddmFormInstanceReport == null) {
            return fieldsJSONArray;
        }
        DDMFormInstance ddmFormInstance = ddmFormInstanceReport.getFormInstance();
        DDMForm ddmForm = ddmFormInstance.getDDMForm();
        Map<String, DDMFormField> ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Set<String> set = ddmFormFieldsMap.keySet();
        Stream stream = set.stream();
        stream.map(ddmFormFieldName -> (DDMFormField)ddmFormFieldsMap.get(ddmFormFieldName)).filter(ddmFormField -> !StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")).forEach(ddmFormField -> fieldsJSONArray.put(JSONUtil.put((String)"columns", (Object)DDMFormReportDataUtil._getPropertyLabelsJSONObject(ddmFormField, "columns")).put("label", DDMFormReportDataUtil._getLabel(ddmFormField)).put("name", ddmFormField.getName()).put("options", DDMFormReportDataUtil._getDDMFormFieldOptionLabelsJSONObject(ddmFormField.getDDMFormFieldOptions())).put("rows", DDMFormReportDataUtil._getPropertyLabelsJSONObject(ddmFormField, "rows")).put("type", ddmFormField.getType())));
        return fieldsJSONArray;
    }

    public static JSONArray getFieldValuesJSONArray(List<DDMFormInstanceRecord> ddmFormInstanceRecords, String fieldName) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDMFormInstanceRecord ddmFormInstanceRecord : ddmFormInstanceRecords) {
            DDMFormValues ddmFormValues = ddmFormInstanceRecord.getDDMFormValues();
            Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(true);
            List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(fieldName);
            if (ddmFormFieldValues == null) continue;
            ddmFormFieldValues.forEach(ddmFormFieldValue -> {
                Value value = ddmFormFieldValue.getValue();
                jsonArray.put(value.getString(value.getDefaultLocale()));
            });
        }
        return jsonArray;
    }

    public static String getLastModifiedDate(DDMFormInstanceReport ddmFormInstanceReport, Locale locale, TimeZone timeZone) {
        if (ddmFormInstanceReport == null) {
            return "";
        }
        String languageKey = "the-last-entry-was-sent-on-x";
        Date modifiedDate = ddmFormInstanceReport.getModifiedDate();
        int daysBetween = DateUtil.getDaysBetween((Date)new Date(modifiedDate.getTime()), (Date)new Date(), (TimeZone)timeZone);
        if (daysBetween < 2) {
            languageKey = "the-last-entry-was-sent-x";
        }
        String relativeTimeDescription = StringUtil.removeSubstring((String)Time.getRelativeTimeDescription((Date)modifiedDate, (Locale)locale, (TimeZone)timeZone), (String)".");
        if (daysBetween < 2) {
            relativeTimeDescription = StringUtil.toLowerCase((String)relativeTimeDescription);
        }
        return LanguageUtil.format((Locale)locale, (String)languageKey, (Object)relativeTimeDescription, (boolean)false);
    }

    public static int getTotalItems(DDMFormInstanceReport ddmFormInstanceReport) throws PortalException {
        if (ddmFormInstanceReport == null) {
            return 0;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)ddmFormInstanceReport.getData());
        return jsonObject.getInt("totalItems");
    }

    private static JSONObject _getDDMFormFieldOptionLabelsJSONObject(DDMFormFieldOptions ddmFormFieldOptions) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        int index = 0;
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            jsonObject.put(optionValue, JSONUtil.put((String)"index", (Object)index++).put("value", DDMFormReportDataUtil._getValue(ddmFormFieldOptions.getOptionLabels(optionValue))));
        }
        return jsonObject;
    }

    private static String _getLabel(DDMFormField ddmFormField) {
        if (StringUtil.equals((String)ddmFormField.getType(), (String)"search_location")) {
            JSONObject jsonObject = JSONUtil.put((String)"place", (Object)DDMFormReportDataUtil._getValue(ddmFormField.getLabel()));
            LocalizedValue visibleFields = (LocalizedValue)ddmFormField.getProperty("visibleFields");
            Stream.of(StringUtil.split((String)StringUtil.removeChars((String)GetterUtil.getString((String)visibleFields.getString(visibleFields.getDefaultLocale())), (char[])new char[]{']', '[', '\"'}))).map(String::trim).forEach(visibleField -> jsonObject.put(visibleField, LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)visibleFields.getDefaultLocale(), DDMFormReportDataUtil.class), (String)visibleField)));
            return jsonObject.toString();
        }
        return DDMFormReportDataUtil._getValue(ddmFormField.getLabel());
    }

    private static JSONObject _getPropertyLabelsJSONObject(DDMFormField ddmFormField, String propertyName) {
        Object property = ddmFormField.getProperty(propertyName);
        if (property instanceof DDMFormFieldOptions) {
            DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)property;
            return DDMFormReportDataUtil._getDDMFormFieldOptionLabelsJSONObject(ddmFormFieldOptions);
        }
        return JSONFactoryUtil.createJSONObject();
    }

    private static String _getValue(Value value) {
        Locale locale;
        Set<Locale> availableLocales = value.getAvailableLocales();
        if (availableLocales.contains(locale = LocaleThreadLocal.getThemeDisplayLocale())) {
            return value.getString(locale);
        }
        return value.getString(value.getDefaultLocale());
    }
}

