/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldParameterNameUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class DDMFormValuesFactoryUtil {
    public static List<DDMFormFieldValue> getDDMFormFieldValues(Map<String, DDMFormFieldValue> ddmFormFieldValuesMap, List<DDMFormField> ddmFormFields) {
        int index = 0;
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            for (String entryKey : DDMFormValuesFactoryUtil._sort(DDMFormValuesFactoryUtil._getEntryKeys(ddmFormFieldValuesMap, ddmFormField.getName(), ""))) {
                DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValuesMap.get(entryKey);
                DDMFormValuesFactoryUtil._setNestedDDMFormFieldValues(ddmFormFieldValuesMap, ddmFormField.getNestedDDMFormFields(), ddmFormFieldValue, entryKey);
                DDMFormValuesFactoryUtil._setDDMFormFieldValueAtIndex(ddmFormFieldValues, ddmFormFieldValue, index++);
            }
        }
        return ddmFormFieldValues;
    }

    private static String _getEntryKeyPrefix(String parentEntryKey, String fieldNameFilter) {
        if (Validator.isNull((String)parentEntryKey)) {
            return "";
        }
        return StringBundler.concat((String[])new String[]{parentEntryKey, "#", fieldNameFilter});
    }

    private static Set<String> _getEntryKeys(Map<String, DDMFormFieldValue> ddmFormFieldValuesMap, String fieldName, String parentEntryKey) {
        HashSet<String> entryKeys = new HashSet<String>();
        for (Map.Entry<String, DDMFormFieldValue> entry : ddmFormFieldValuesMap.entrySet()) {
            DDMFormFieldValue ddmFormFieldValue = entry.getValue();
            String key = entry.getKey();
            if (!key.startsWith(DDMFormValuesFactoryUtil._getEntryKeyPrefix(parentEntryKey, fieldName)) && !key.startsWith(fieldName + "$") || !Objects.equals(ddmFormFieldValue.getName(), fieldName)) continue;
            entryKeys.add(key);
        }
        return entryKeys;
    }

    private static void _setDDMFormFieldValueAtIndex(List<DDMFormFieldValue> ddmFormFieldValues, DDMFormFieldValue ddmFormFieldValue, int index) {
        if (ddmFormFieldValues.size() < index + 1) {
            for (int i = ddmFormFieldValues.size(); i <= index; ++i) {
                ddmFormFieldValues.add(new DDMFormFieldValue());
            }
        }
        ddmFormFieldValues.set(index, ddmFormFieldValue);
    }

    private static void _setNestedDDMFormFieldValues(Map<String, DDMFormFieldValue> ddmFormFieldValuesMap, List<DDMFormField> nestedDDMFormFields, DDMFormFieldValue parentDDMFormFieldValue, String parentEntryKey) {
        int index = 0;
        for (DDMFormField nestedDDMFormField : nestedDDMFormFields) {
            for (String entryKey : DDMFormValuesFactoryUtil._sort(DDMFormValuesFactoryUtil._getEntryKeys(ddmFormFieldValuesMap, nestedDDMFormField.getName(), parentEntryKey))) {
                DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValuesMap.get(entryKey);
                DDMFormValuesFactoryUtil._setNestedDDMFormFieldValues(ddmFormFieldValuesMap, nestedDDMFormField.getNestedDDMFormFields(), ddmFormFieldValue, entryKey);
                DDMFormValuesFactoryUtil._setDDMFormFieldValueAtIndex(parentDDMFormFieldValue.getNestedDDMFormFieldValues(), ddmFormFieldValue, index++);
            }
        }
    }

    private static Collection<String> _sort(Set<String> entryKeys) {
        TreeMap<Integer, String> entryKeysMap = new TreeMap<Integer, String>();
        for (String key : entryKeys) {
            entryKeysMap.put(GetterUtil.getInteger((String)DDMFormFieldParameterNameUtil.getLastDDMFormFieldParameterNameParts(key)[2]), key);
        }
        return entryKeysMap.values();
    }
}

