/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class DDMDataProviderRequest {
    private long _companyId;
    private String _ddmDataProviderId;
    private long _groupId;
    private Locale _locale;
    private final Map<String, Object> _parameters = new HashMap<String, Object>();

    public long getCompanyId() {
        return this._companyId;
    }

    public String getDDMDataProviderId() {
        return this._ddmDataProviderId;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public <T> T getParameter(String name, Class<?> clazz) {
        Object value = this._parameters.get(name);
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (clazz.isAssignableFrom(valueClass)) {
            return (T)value;
        }
        return null;
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this._parameters);
    }

    private DDMDataProviderRequest() {
    }

    public static class Builder {
        private final DDMDataProviderRequest _ddmDataProviderRequest = new DDMDataProviderRequest();

        public static Builder newBuilder() {
            return new Builder();
        }

        public DDMDataProviderRequest build() {
            return this._ddmDataProviderRequest;
        }

        public Builder withCompanyId(long companyId) {
            this._ddmDataProviderRequest._companyId = companyId;
            return this;
        }

        public Builder withDDMDataProviderId(String ddmDataProviderId) {
            this._ddmDataProviderRequest._ddmDataProviderId = ddmDataProviderId;
            return this;
        }

        public Builder withGroupId(long groupId) {
            this._ddmDataProviderRequest._groupId = groupId;
            return this;
        }

        public Builder withLocale(Locale locale) {
            this._ddmDataProviderRequest._locale = locale;
            return this;
        }

        public Builder withParameter(String name, Object value) {
            this._ddmDataProviderRequest._parameters.put(name, value);
            return this;
        }

        private Builder() {
        }
    }
}

