/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DDMFormValuesTransformer {
    private final Map<String, DDMFormFieldValueTransformer> _ddmFormFieldValueTransformersMap = new HashMap<String, DDMFormFieldValueTransformer>();
    private final DDMFormValues _ddmFormValues;

    public DDMFormValuesTransformer(DDMFormValues ddmFormValues) {
        this._ddmFormValues = ddmFormValues;
    }

    public void addTransformer(DDMFormFieldValueTransformer ddmFormFieldValueTransformer) {
        this._ddmFormFieldValueTransformersMap.put(ddmFormFieldValueTransformer.getFieldType(), ddmFormFieldValueTransformer);
    }

    public void transform() throws PortalException {
        DDMForm ddmForm = this._ddmFormValues.getDDMForm();
        this.traverse(ddmForm.getDDMFormFields(), this._ddmFormValues.getDDMFormFieldValuesMap());
    }

    protected void performTransformation(List<DDMFormFieldValue> ddmFormFieldValues, DDMFormFieldValueTransformer ddmFormFieldValueTransformer) throws PortalException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            ddmFormFieldValueTransformer.transform(ddmFormFieldValue);
        }
    }

    protected void traverse(List<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap) throws PortalException {
        for (DDMFormField ddmFormField : ddmFormFields) {
            List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(ddmFormField.getName());
            if (ddmFormFieldValues == null) continue;
            String type = ddmFormField.getType();
            if (StringUtil.equals((String)type, (String)"ddm-documentlibrary")) {
                type = "document_library";
            } else if (StringUtil.equals((String)type, (String)"ddm-journal-article")) {
                type = "journal_article";
            } else if (StringUtil.equals((String)type, (String)"ddm-link-to-page")) {
                type = "link_to_layout";
            } else if (StringUtil.equals((String)type, (String)"ddm-text-html")) {
                type = "rich_text";
            }
            if (this._ddmFormFieldValueTransformersMap.containsKey(type)) {
                this.performTransformation(ddmFormFieldValues, this._ddmFormFieldValueTransformersMap.get(type));
            }
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                this.traverse(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValue.getNestedDDMFormFieldValuesMap());
            }
        }
    }
}

