/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.model;

import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class FunctionCallExpression
extends Expression {
    private final String _functionName;
    private final List<Expression> _parameterExpressions;

    public FunctionCallExpression(String functionName, List<Expression> parameterExpressions) {
        this._functionName = functionName;
        this._parameterExpressions = parameterExpressions;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> expressionVisitor) {
        return expressionVisitor.visit(this);
    }

    public int getArity() {
        return this._parameterExpressions.size();
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public List<Expression> getParameterExpressions() {
        return this._parameterExpressions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._functionName);
        sb.append("(");
        Stream expressionStream = this._parameterExpressions.stream();
        Stream<String> expressionStringStream = expressionStream.map(expression -> expression.toString());
        sb.append(expressionStringStream.collect(Collectors.joining(", ")));
        sb.append(")");
        return sb.toString();
    }
}

