/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model;

import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMFormFieldOptions
implements Serializable {
    private Locale _defaultLocale;
    private final Map<String, LocalizedValue> _options = new LinkedHashMap<String, LocalizedValue>();

    public DDMFormFieldOptions() {
        this._defaultLocale = LocaleUtil.getDefault();
    }

    public DDMFormFieldOptions(DDMFormFieldOptions ddmFormFieldOptions) {
        this._defaultLocale = ddmFormFieldOptions._defaultLocale;
        Map<String, LocalizedValue> options = ddmFormFieldOptions._options;
        for (Map.Entry<String, LocalizedValue> entry : options.entrySet()) {
            LocalizedValue localizedValue = entry.getValue();
            for (Locale locale : localizedValue.getAvailableLocales()) {
                this.addOptionLabel(entry.getKey(), locale, localizedValue.getString(locale));
            }
        }
    }

    public void addOption(String value) {
        this._options.put(value, new LocalizedValue(this._defaultLocale));
    }

    public void addOptionLabel(String optionValue, Locale locale, String label) {
        LocalizedValue labels = this._options.get(optionValue);
        if (labels == null) {
            labels = new LocalizedValue(this._defaultLocale);
            this._options.put(optionValue, labels);
        }
        labels.addString(locale, label);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DDMFormFieldOptions)) {
            return false;
        }
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)obj;
        return Objects.equals(this._defaultLocale, ddmFormFieldOptions._defaultLocale) && Objects.equals(this._options, ddmFormFieldOptions._options);
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public LocalizedValue getOptionLabels(String optionValue) {
        return this._options.get(optionValue);
    }

    public Map<String, LocalizedValue> getOptions() {
        return this._options;
    }

    public Set<String> getOptionsValues() {
        return this._options.keySet();
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)this._defaultLocale);
        return HashUtil.hash((int)hash, this._options);
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
        for (LocalizedValue localizedValue : this._options.values()) {
            localizedValue.setDefaultLocale(defaultLocale);
        }
    }
}

