/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInputParametersSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderOutputParametersSettings;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldFactoryHelper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public class DDMFormFactoryHelper {
    private static final Class<? extends Annotation> _DDM_FORM_FIELD_ANNOTATION = com.liferay.dynamic.data.mapping.annotations.DDMFormField.class;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormFactoryHelper.class);
    private final Set<Locale> _availableLocales;
    private final Class<?> _clazz;
    private final com.liferay.dynamic.data.mapping.annotations.DDMForm _ddmForm;
    private final Locale _defaultLocale;
    private Map<Locale, ResourceBundle> _resourceBundles;

    public DDMFormFactoryHelper(Class<?> clazz) {
        this._clazz = clazz;
        this._ddmForm = clazz.getAnnotation(com.liferay.dynamic.data.mapping.annotations.DDMForm.class);
        this._availableLocales = this.getAvailableLocales();
        this._defaultLocale = this.getDefaultLocale();
    }

    public DDMForm createDDMForm() {
        DDMForm ddmForm = new DDMForm();
        ddmForm.setAvailableLocales(this._availableLocales);
        ddmForm.setDefaultLocale(this._defaultLocale);
        ddmForm.setDDMFormFields(this.getDDMFormFields());
        ddmForm.setDDMFormRules(this.getDDMFormRules());
        return ddmForm;
    }

    protected void collectDDMFormFieldMethodsMap(Class<?> clazz, Map<String, Method> methodsMap) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.collectDDMFormFieldMethodsMap(clazz2, methodsMap);
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
            if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(_DDM_FORM_FIELD_ANNOTATION)) continue;
            methodsMap.put(((Method)genericDeclaration).getName(), (Method)genericDeclaration);
        }
    }

    protected void collectResourceBundles(Class<?> clazz, List<ResourceBundle> resourceBundles, Locale locale) {
        block5: {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                this.collectResourceBundles(interfaceClass, resourceBundles, locale);
            }
            String resourceBundleBaseName = this.getResourceBundleBaseName();
            if (Validator.isNull((String)resourceBundleBaseName)) {
                return;
            }
            try {
                ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)resourceBundleBaseName, (Locale)locale, (ClassLoader)clazz.getClassLoader());
                if (resourceBundle != null) {
                    resourceBundles.add(resourceBundle);
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)missingResourceException, (Throwable)missingResourceException);
            }
        }
    }

    protected Set<Locale> getAvailableLocales() {
        if (Validator.isNull((String)this._ddmForm.availableLanguageIds())) {
            return SetUtil.fromArray((Object[])new Locale[]{this.getDefaultLocale()});
        }
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (String availableLanguageId : StringUtil.split((String)this._ddmForm.availableLanguageIds())) {
            availableLocales.add(LocaleUtil.fromLanguageId((String)availableLanguageId));
        }
        return availableLocales;
    }

    protected Collection<Method> getDDMFormFieldMethods() {
        LinkedHashMap<String, Method> methodsMap = new LinkedHashMap<String, Method>();
        this.collectDDMFormFieldMethodsMap(this._clazz, methodsMap);
        String className = this._clazz.getName();
        if (className.equals(DDMDataProviderInputParametersSettings.class.getName()) || className.equals(DDMDataProviderOutputParametersSettings.class.getName())) {
            return this.getSortedMethods(methodsMap);
        }
        return methodsMap.values();
    }

    protected List<DDMFormField> getDDMFormFields() {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (Method method : this.getDDMFormFieldMethods()) {
            DDMFormFieldFactoryHelper ddmFormFieldFactoryHelper = new DDMFormFieldFactoryHelper(this, method);
            ddmFormFieldFactoryHelper.setAvailableLocales(this._availableLocales);
            ddmFormFieldFactoryHelper.setDefaultLocale(this._defaultLocale);
            ddmFormFields.add(ddmFormFieldFactoryHelper.createDDMFormField());
        }
        return ddmFormFields;
    }

    protected List<DDMFormRule> getDDMFormRules() {
        ArrayList<DDMFormRule> ddmFormRules = new ArrayList<DDMFormRule>();
        for (com.liferay.dynamic.data.mapping.annotations.DDMFormRule ddmFormRule : this._ddmForm.rules()) {
            ddmFormRules.add(new DDMFormRule(ListUtil.fromArray((Object[])ddmFormRule.actions()), ddmFormRule.condition()));
        }
        return ddmFormRules;
    }

    protected Locale getDefaultLocale() {
        if (Validator.isNull((String)this._ddmForm.defaultLanguageId())) {
            return Optional.ofNullable(LocaleThreadLocal.getThemeDisplayLocale()).orElse(Optional.ofNullable(LocaleThreadLocal.getSiteDefaultLocale()).orElse(LocaleUtil.getDefault()));
        }
        return LocaleUtil.fromLanguageId((String)this._ddmForm.defaultLanguageId());
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        if (this._resourceBundles == null) {
            this._resourceBundles = new HashMap<Locale, ResourceBundle>();
        }
        return this._resourceBundles.computeIfAbsent(locale, key -> {
            ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
            ResourceBundle portalResourceBundle = PortalUtil.getResourceBundle((Locale)locale);
            resourceBundles.add(portalResourceBundle);
            this.collectResourceBundles(this._clazz, resourceBundles, locale);
            ResourceBundle[] resourceBundlesArray = resourceBundles.toArray(new ResourceBundle[0]);
            return new AggregateResourceBundle(resourceBundlesArray);
        });
    }

    protected String getResourceBundleBaseName() {
        if (!this._clazz.isAnnotationPresent(com.liferay.dynamic.data.mapping.annotations.DDMForm.class)) {
            return null;
        }
        com.liferay.dynamic.data.mapping.annotations.DDMForm ddmForm = this._clazz.getAnnotation(com.liferay.dynamic.data.mapping.annotations.DDMForm.class);
        if (Validator.isNotNull((String)ddmForm.localization())) {
            return ddmForm.localization();
        }
        return "content.Language";
    }

    protected Collection<Method> getSortedMethods(Map<String, Method> methodsMap) {
        LinkedHashMap<String, Method> sortedMethodsMap = new LinkedHashMap<String, Method>();
        TreeSet<String> keys = new TreeSet<String>(methodsMap.keySet());
        for (String key : keys) {
            sortedMethodsMap.put(key, methodsMap.get(key));
        }
        this.moveInputParameterRequiredToLastPosition(sortedMethodsMap);
        return sortedMethodsMap.values();
    }

    protected void moveInputParameterRequiredToLastPosition(Map<String, Method> methodsMap) {
        Method inputParameterRequiredMethod = methodsMap.get("inputParameterRequired");
        if (inputParameterRequiredMethod == null) {
            return;
        }
        methodsMap.remove("inputParameterRequired");
        methodsMap.put("inputParameterRequired", inputParameterRequiredMethod);
    }
}

