/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.annotations.DDMFormFieldProperty;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormFactoryHelper;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DDMFormFieldFactoryHelper {
    private Set<Locale> _availableLocales;
    private final DDMFormFactoryHelper _ddmFormFactoryHelper;
    private final com.liferay.dynamic.data.mapping.annotations.DDMFormField _ddmFormField;
    private Locale _defaultLocale;
    private final Method _method;

    public DDMFormFieldFactoryHelper(DDMFormFactoryHelper ddmFormFactoryHelper, Method method) {
        this._ddmFormFactoryHelper = ddmFormFactoryHelper;
        this._method = method;
        this._ddmFormField = method.getAnnotation(com.liferay.dynamic.data.mapping.annotations.DDMFormField.class);
    }

    public DDMFormField createDDMFormField() {
        String name = this.getDDMFormFieldName();
        String type = this.getDDMFormFieldType();
        DDMFormField ddmFormField = new DDMFormField(name, type);
        Map<String, Object> properties = this.getProperties();
        properties.putAll(this.getDDMFormFieldProperties());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String[]) {
                ddmFormField.setProperty(entry.getKey(), Stream.of((String[])value).map(this::getValue).toArray());
                continue;
            }
            ddmFormField.setProperty(entry.getKey(), this.getValue(value));
        }
        ddmFormField.setDataType(this.getDDMFormFieldDataType());
        ddmFormField.setDDMFormFieldOptions(this.getDDMFormFieldOptions());
        ddmFormField.setDDMFormFieldValidation(this.getDDMFormFieldValidation());
        ddmFormField.setLabel(this.getDDMFormFieldLabel());
        ddmFormField.setLocalizable(this.isDDMFormFieldLocalizable());
        ddmFormField.setPredefinedValue(this.getDDMFormFieldPredefinedValue());
        ddmFormField.setRepeatable(this.isDDMFormFieldRepeatable());
        ddmFormField.setRequired(this.isDDMFormFieldRequired());
        ddmFormField.setTip(this.getDDMFormFieldTip());
        ddmFormField.setVisibilityExpression(this.getDDMFormFieldVisibilityExpression());
        if (Objects.equals(type, "fieldset")) {
            DDMForm nestedDDMForm = this._getNestedDDMForm();
            ddmFormField.setNestedDDMFormFields(nestedDDMForm.getDDMFormFields());
        }
        return ddmFormField;
    }

    protected LocalizedValue createLocalizedValue(String property) {
        LocalizedValue localizedValue = new LocalizedValue(this._defaultLocale);
        if (Validator.isNull((String)property)) {
            return localizedValue;
        }
        if (this.isLocalizableValue(property)) {
            String languageKey = this.extractLanguageKey(property);
            for (Locale availableLocale : this._availableLocales) {
                localizedValue.addString(availableLocale, this.getLocalizedValue(availableLocale, languageKey));
            }
        } else {
            localizedValue.addString(this._defaultLocale, property);
        }
        return localizedValue;
    }

    protected String extractLanguageKey(String value) {
        return StringUtil.extractLast((String)value, (String)"%");
    }

    protected String getDDMFormFieldDataType() {
        if (Validator.isNotNull((String)this._ddmFormField.dataType())) {
            return this._ddmFormField.dataType();
        }
        Class<Object> returnType = this._getReturnType();
        if (returnType.isAnnotationPresent(com.liferay.dynamic.data.mapping.annotations.DDMForm.class) || returnType.isAssignableFrom(Void.TYPE)) {
            return "";
        }
        if (returnType.isAssignableFrom(Boolean.TYPE) || returnType.isAssignableFrom(Boolean.class)) {
            return "boolean";
        }
        if (returnType.isAssignableFrom(Double.TYPE) || returnType.isAssignableFrom(Double.class)) {
            return "double";
        }
        if (returnType.isAssignableFrom(Float.TYPE) || returnType.isAssignableFrom(Float.class)) {
            return "float";
        }
        if (returnType.isAssignableFrom(Integer.TYPE) || returnType.isAssignableFrom(Integer.class)) {
            return "integer";
        }
        if (returnType.isAssignableFrom(Long.TYPE) || returnType.isAssignableFrom(Long.class)) {
            return "long";
        }
        if (returnType.isAssignableFrom(Short.TYPE) || returnType.isAssignableFrom(Short.class)) {
            return "short";
        }
        return "string";
    }

    protected LocalizedValue getDDMFormFieldLabel() {
        return this.createLocalizedValue(this._ddmFormField.label());
    }

    protected String getDDMFormFieldName() {
        if (Validator.isNotNull((String)this._ddmFormField.name())) {
            return this._ddmFormField.name();
        }
        return this._method.getName();
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions() {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        ddmFormFieldOptions.setDefaultLocale(this._defaultLocale);
        Object[] optionLabels = this._ddmFormField.optionLabels();
        Object[] optionValues = this._ddmFormField.optionValues();
        if (ArrayUtil.isEmpty((Object[])optionLabels) || ArrayUtil.isEmpty((Object[])optionValues)) {
            return ddmFormFieldOptions;
        }
        for (int i = 0; i < optionLabels.length; ++i) {
            Object optionLabel = optionLabels[i];
            if (this.isLocalizableValue((String)optionLabel)) {
                String languageKey = this.extractLanguageKey((String)optionLabel);
                ddmFormFieldOptions.addOptionLabel((String)optionValues[i], this._defaultLocale, this.getLocalizedValue(this._defaultLocale, languageKey));
            } else {
                ddmFormFieldOptions.addOptionLabel((String)optionValues[i], this._defaultLocale, (String)optionLabel);
            }
            ddmFormFieldOptions.addOptionReference((String)optionValues[i], (String)optionValues[i]);
        }
        return ddmFormFieldOptions;
    }

    protected LocalizedValue getDDMFormFieldPredefinedValue() {
        LocalizedValue localizedValue = new LocalizedValue(this._defaultLocale);
        String predefinedValue = this._ddmFormField.predefinedValue();
        String fieldType = this.getDDMFormFieldType();
        if (Validator.isNotNull((String)predefinedValue)) {
            if (StringUtil.startsWith((String)predefinedValue, (String)"%")) {
                return this.createLocalizedValue(predefinedValue);
            }
            localizedValue.addString(this._defaultLocale, predefinedValue);
        } else if (fieldType.equals("checkbox")) {
            localizedValue.addString(this._defaultLocale, Boolean.FALSE.toString());
        }
        return localizedValue;
    }

    protected Map<String, String[]> getDDMFormFieldProperties() {
        return Stream.of(this._ddmFormField.ddmFormFieldProperties()).collect(Collectors.toMap(DDMFormFieldProperty::name, DDMFormFieldProperty::value));
    }

    protected LocalizedValue getDDMFormFieldTip() {
        return this.createLocalizedValue(this._ddmFormField.tip());
    }

    protected String getDDMFormFieldType() {
        if (Validator.isNotNull((String)this._ddmFormField.type())) {
            return this._ddmFormField.type();
        }
        Class<Boolean> returnType = this._getReturnType();
        if (returnType.isAnnotationPresent(com.liferay.dynamic.data.mapping.annotations.DDMForm.class)) {
            return "fieldset";
        }
        if (returnType.isAssignableFrom(Boolean.TYPE) || returnType.isAssignableFrom(Boolean.class)) {
            return "checkbox";
        }
        return "text";
    }

    protected DDMFormFieldValidation getDDMFormFieldValidation() {
        if (Validator.isNull((String)this._ddmFormField.validationExpression()) && Validator.isNull((String)this._ddmFormField.validationErrorMessage())) {
            return null;
        }
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        if (Validator.isNotNull((String)this._ddmFormField.validationExpression())) {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setValue(DDMFormFieldFactoryHelper.this._ddmFormField.validationExpression());
                }
            });
        }
        if (Validator.isNotNull((String)this._ddmFormField.validationErrorMessage())) {
            String validationErrorMessage = this._ddmFormField.validationErrorMessage();
            if (this.isLocalizableValue(validationErrorMessage)) {
                String languageKey = this.extractLanguageKey(validationErrorMessage);
                validationErrorMessage = this.getLocalizedValue(this._defaultLocale, languageKey);
            }
            ddmFormFieldValidation.setErrorMessageLocalizedValue(this.createLocalizedValue(validationErrorMessage));
        }
        return ddmFormFieldValidation;
    }

    protected String getDDMFormFieldVisibilityExpression() {
        if (Validator.isNotNull((String)this._ddmFormField.visibilityExpression())) {
            return this._ddmFormField.visibilityExpression();
        }
        return StringUtil.toUpperCase((String)"true");
    }

    protected String getLocalizedValue(Locale locale, String value) {
        return LanguageUtil.get((ResourceBundle)this._ddmFormFactoryHelper.getResourceBundle(locale), (String)value);
    }

    @Deprecated
    protected Map<String, Object> getProperties() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        for (String property : this._ddmFormField.properties()) {
            String[] propertyParts = property.split("=", 2);
            propertiesMap.put(propertyParts[0], propertyParts[1]);
        }
        return propertiesMap;
    }

    @Deprecated
    protected LocalizedValue getPropertyValue(Object value) {
        LocalizedValue localizedValue = new LocalizedValue(this._defaultLocale);
        if (Validator.isNull((Object)value)) {
            return localizedValue;
        }
        String valueString = (String)value;
        if (this.isLocalizableValue(valueString)) {
            String languageKey = this.extractLanguageKey(valueString);
            localizedValue.addString(this._defaultLocale, this.getLocalizedValue(this._defaultLocale, languageKey));
        } else {
            localizedValue.addString(this._defaultLocale, valueString);
        }
        return localizedValue;
    }

    protected Object getValue(Object value) {
        if (!this.isLocalizableValue(value.toString())) {
            return value;
        }
        LocalizedValue localizedValue = new LocalizedValue(this._defaultLocale);
        if (Validator.isNull((Object)value)) {
            return localizedValue;
        }
        String valueString = (String)value;
        if (this.isLocalizableValue(valueString)) {
            String languageKey = this.extractLanguageKey(valueString);
            localizedValue.addString(this._defaultLocale, this.getLocalizedValue(this._defaultLocale, languageKey));
        } else {
            localizedValue.addString(this._defaultLocale, valueString);
        }
        return localizedValue;
    }

    protected boolean isDDMFormFieldLocalizable() {
        Class<LocalizedValue> returnType = this._method.getReturnType();
        return returnType.isAssignableFrom(LocalizedValue.class);
    }

    protected boolean isDDMFormFieldRepeatable() {
        Class<?> returnType = this._method.getReturnType();
        return returnType.isArray();
    }

    protected boolean isDDMFormFieldRequired() {
        return this._ddmFormField.required();
    }

    protected boolean isLocalizableValue(String value) {
        return value != null && !value.isEmpty() && value.charAt(0) == '%';
    }

    protected void setAvailableLocales(Set<Locale> availableLocales) {
        this._availableLocales = availableLocales;
    }

    protected void setDefaultLocale(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
    }

    private DDMForm _getNestedDDMForm() {
        return DDMFormFactory.create(this._getReturnType());
    }

    private Class<?> _getReturnType() {
        Class<?> returnType = this._method.getReturnType();
        if (returnType.isArray()) {
            returnType = returnType.getComponentType();
        }
        return returnType;
    }
}

