/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.Locale;

public class DocumentLibraryDDMFormFieldValueTransformer
implements DDMFormFieldValueTransformer {
    @Override
    public String getFieldType() {
        return "document_library";
    }

    @Override
    public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        for (Locale locale : value.getAvailableLocales()) {
            FileEntry tempFileEntry = this.fetchTempFileEntry(value.getString(locale));
            if (tempFileEntry == null) continue;
            FileEntry fileEntry = this.addFileEntry(tempFileEntry);
            value.addString(locale, this.toJSON(fileEntry));
        }
    }

    protected FileEntry addFileEntry(FileEntry tempFileEntry) throws PortalException {
        String fileName = DLUtil.getUniqueFileName((long)tempFileEntry.getGroupId(), (long)tempFileEntry.getFolderId(), (String)tempFileEntry.getFileName());
        return DLAppServiceUtil.addFileEntry(null, (long)tempFileEntry.getGroupId(), (long)0L, (String)fileName, (String)tempFileEntry.getMimeType(), (String)fileName, (String)"", (String)"", (InputStream)tempFileEntry.getContentStream(), (long)tempFileEntry.getSize(), null, null, (ServiceContext)new ServiceContext());
    }

    protected FileEntry fetchTempFileEntry(String value) throws PortalException {
        if (Validator.isNull((String)value)) {
            return null;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
        boolean tempFile = jsonObject.getBoolean("tempFile");
        if (!tempFile) {
            return null;
        }
        return DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)jsonObject.getString("uuid"), (long)jsonObject.getLong("groupId"));
    }

    protected String toJSON(FileEntry fileEntry) {
        JSONObject jsonObject = JSONUtil.put((String)"groupId", (Object)fileEntry.getGroupId()).put("title", fileEntry.getTitle()).put("uuid", fileEntry.getUuid());
        return jsonObject.toString();
    }
}

