/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.demo.data.creator.internal;

import com.liferay.dynamic.data.mapping.demo.data.creator.DDMFormInstanceDemoDataCreator;
import com.liferay.dynamic.data.mapping.demo.data.creator.DDMStructureDemoDataCreator;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormInstanceDemoDataCreator.class})
public class DDMFormInstanceDemoDataCreatorImpl
implements DDMFormInstanceDemoDataCreator {
    private final List<Long> _ddmFormInstanceIds = new CopyOnWriteArrayList<Long>();
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference
    private DDMStructureDemoDataCreator _ddmStructureDemoDataCreator;

    public DDMFormInstance create(long userId, long groupId, Date createDate) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureDemoDataCreator.create(groupId, userId);
        DDMFormValues ddmFormValues = new DDMFormValues(new DDMForm(){
            {
                this.setAvailableLocales(Collections.singleton(LocaleUtil.US));
                this.setDefaultLocale(LocaleUtil.US);
            }
        }){
            {
                this.setAvailableLocales(Collections.singleton(LocaleUtil.US));
                this.setDefaultLocale(LocaleUtil.US);
            }
        };
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceLocalService.addFormInstance(ddmStructure.getUserId(), ddmStructure.getGroupId(), ddmStructure.getStructureId(), ddmStructure.getNameMap(), ddmStructure.getNameMap(), ddmFormValues, serviceContext);
        if (createDate != null) {
            ddmFormInstance.setCreateDate(createDate);
            ddmFormInstance = this._ddmFormInstanceLocalService.updateDDMFormInstance(ddmFormInstance);
        }
        this._ddmFormInstanceIds.add(ddmFormInstance.getFormInstanceId());
        return ddmFormInstance;
    }

    public void delete() throws PortalException {
        for (Long ddmFormInstanceId : this._ddmFormInstanceIds) {
            this._ddmFormInstanceIds.remove(ddmFormInstanceId);
            this._ddmFormInstanceLocalService.deleteFormInstance(ddmFormInstanceId.longValue());
        }
        this._ddmStructureDemoDataCreator.delete();
    }
}

