/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.helper;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionActionHandler;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserver;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyResponse;
import com.liferay.dynamic.data.mapping.expression.UpdateFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateResponse;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorFieldContextKey;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionActionHandler;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionObserver;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.helper.DDMFormEvaluatorFormValuesHelper;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.helper.DDMFormEvaluatorRuleHelper;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueEditingAware;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueLocalizer;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DDMFormEvaluatorHelper {
    protected final DDMFormEvaluatorExpressionFieldAccessor ddmFormEvaluatorDDMExpressionFieldAccessor;
    protected DDMFormEvaluatorExpressionActionHandler ddmFormEvaluatorExpressionActionHandler;
    protected final DDMFormEvaluatorExpressionObserver ddmFormEvaluatorExpressionObserver;
    protected final DDMFormEvaluatorExpressionParameterAccessor ddmFormEvaluatorExpressionParameterAccessor;
    protected final DDMFormFieldValueAccessor<String> defaultDDMFormFieldValueAccessor = new DefaultDDMFormFieldValueAccessor();
    private static final Log _log = LogFactoryUtil.getLog(DDMFormEvaluatorHelper.class);
    private final DDMExpressionFactory _ddmExpressionFactory;
    private final DDMForm _ddmForm;
    private final DDMFormEvaluatorEvaluateRequest _ddmFormEvaluatorEvaluateRequest;
    private final DDMFormEvaluatorFormValuesHelper _ddmFormEvaluatorFormValuesHelper;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private final Map<DDMFormEvaluatorFieldContextKey, Map<String, Object>> _ddmFormFieldsPropertyChanges = new HashMap<DDMFormEvaluatorFieldContextKey, Map<String, Object>>();
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final DDMFormLayout _ddmFormLayout;
    private final DDMFormEvaluatorRuleHelper _ddmFormRuleHelper;
    private List<String> _evaluatedActions;
    private final Map<Integer, Integer> _pageFlow = new HashMap<Integer, Integer>();
    private ResourceBundle _resourceBundle;

    public DDMFormEvaluatorHelper(DDMFormEvaluatorEvaluateRequest ddmFormEvaluatorEvaluateRequest, DDMExpressionFactory ddmExpressionFactory, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormEvaluatorEvaluateRequest = ddmFormEvaluatorEvaluateRequest;
        this._ddmExpressionFactory = ddmExpressionFactory;
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
        this.createResourceBundle(this._ddmFormEvaluatorEvaluateRequest.getLocale());
        this._ddmForm = ddmFormEvaluatorEvaluateRequest.getDDMForm();
        this._ddmFormEvaluatorFormValuesHelper = new DDMFormEvaluatorFormValuesHelper(this._ddmFormEvaluatorEvaluateRequest.getDDMFormValues());
        this.ddmFormEvaluatorExpressionObserver = new DDMFormEvaluatorExpressionObserver(this._ddmFormEvaluatorFormValuesHelper, this._ddmFormFieldsPropertyChanges);
        this._ddmFormFieldsMap = this._ddmForm.getDDMFormFieldsMap(true);
        this._ddmFormLayout = ddmFormEvaluatorEvaluateRequest.getDDMFormLayout();
        this._ddmFormRuleHelper = new DDMFormEvaluatorRuleHelper(this._ddmFormFieldsMap, this.ddmFormEvaluatorExpressionObserver);
        this.ddmFormEvaluatorDDMExpressionFieldAccessor = new DDMFormEvaluatorExpressionFieldAccessor(this._ddmFormEvaluatorFormValuesHelper, this._ddmFormFieldsMap, this._ddmFormFieldsPropertyChanges, this._ddmFormFieldTypeServicesTracker, ddmFormEvaluatorEvaluateRequest.getLocale());
        this.ddmFormEvaluatorExpressionActionHandler = new DDMFormEvaluatorExpressionActionHandler(this._pageFlow);
        this.ddmFormEvaluatorExpressionParameterAccessor = new DDMFormEvaluatorExpressionParameterAccessor(this._ddmFormEvaluatorEvaluateRequest);
    }

    public DDMFormEvaluatorEvaluateResponse evaluate() {
        this.evaluateVisibilityExpressions();
        List ddmFormRules = null;
        ddmFormRules = this._ddmFormLayout != null && ListUtil.isNotEmpty((List)this._ddmFormLayout.getDDMFormRules()) ? this._ddmFormLayout.getDDMFormRules() : this._ddmForm.getDDMFormRules();
        Stream stream = ddmFormRules.stream();
        stream.filter(DDMFormRule::isEnabled).forEach(rule -> {
            this.evaluateDDMFormRule((DDMFormRule)rule);
            this._resetInvisibleFieldValue();
        });
        this.verifyFieldsMarkedAsRequired();
        this.validateFields();
        this._localizeNumericDDMFormFieldValues();
        return this.buildDDMFormEvaluatorEvaluateResponse();
    }

    protected DDMFormEvaluatorEvaluateResponse buildDDMFormEvaluatorEvaluateResponse() {
        DDMFormEvaluatorEvaluateResponse.Builder formEvaluatorEvaluateResponse = DDMFormEvaluatorEvaluateResponse.Builder.newBuilder(this.getDDMFormFieldsPropertyChanges());
        formEvaluatorEvaluateResponse.withDisabledPagesIndexes(this.getDisabledPagesIndexes());
        return formEvaluatorEvaluateResponse.build();
    }

    protected <T> DDMExpression<T> createExpression(String expression) throws DDMExpressionException {
        CreateExpressionRequest.Builder createExpressionRequestBuilder = CreateExpressionRequest.Builder.newBuilder((String)expression);
        createExpressionRequestBuilder.withDDMExpressionActionHandler((DDMExpressionActionHandler)this.ddmFormEvaluatorExpressionActionHandler).withDDMExpressionFieldAccessor((DDMExpressionFieldAccessor)this.ddmFormEvaluatorDDMExpressionFieldAccessor).withDDMExpressionObserver((DDMExpressionObserver)this.ddmFormEvaluatorExpressionObserver).withDDMExpressionParameterAccessor((DDMExpressionParameterAccessor)this.ddmFormEvaluatorExpressionParameterAccessor);
        return this._ddmExpressionFactory.createExpression(createExpressionRequestBuilder.build());
    }

    protected void createResourceBundle(Locale locale) {
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        ResourceBundle portalResourceBundle = portalResourceBundleLoader.loadResourceBundle(locale);
        ResourceBundle portletResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        this._resourceBundle = new AggregateResourceBundle(new ResourceBundle[]{portletResourceBundle, portalResourceBundle});
    }

    protected void evaluateDDMFormRule(DDMFormRule ddmFormRule) {
        if (Validator.isNotNull((String)ddmFormRule.getCondition())) {
            if (this.evaluateDDMFormRuleCondition(ddmFormRule.getCondition())) {
                List actions = ddmFormRule.getActions();
                Stream stream = actions.stream();
                this.evaluateDDMFormRuleAction(stream.collect(Collectors.joining(" AND ")));
                this._evaluatedActions = ListUtil.copy((List)actions);
            } else {
                DDMFormRule copyDDMFormRule = new DDMFormRule(ddmFormRule);
                if (this._evaluatedActions != null) {
                    List actions = copyDDMFormRule.getActions();
                    Stream stream = actions.stream();
                    List actionsNotEvaluated = stream.filter(action -> !this._evaluatedActions.contains(action)).collect(Collectors.toList());
                    copyDDMFormRule.setActions(actionsNotEvaluated);
                }
                this._ddmFormRuleHelper.checkFieldAffectedByAction(copyDDMFormRule);
            }
        }
    }

    protected void evaluateDDMFormRuleAction(String action) {
        block2: {
            try {
                this.evaluateExpression(action);
            }
            catch (DDMExpressionException ddmExpressionException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)ddmExpressionException, (Throwable)ddmExpressionException);
            }
        }
    }

    protected boolean evaluateDDMFormRuleCondition(String condition) {
        try {
            return (Boolean)this.evaluateExpression(condition);
        }
        catch (DDMExpressionException ddmExpressionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ddmExpressionException, (Throwable)ddmExpressionException);
            }
            return false;
        }
    }

    protected <T> T evaluateExpression(String expression) throws DDMExpressionException {
        DDMExpression<T> ddmExpression = this.createExpression(expression);
        return (T)ddmExpression.evaluate();
    }

    protected void evaluateVisibilityExpression(Map.Entry<String, String> entry) {
        block2: {
            try {
                UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)entry.getKey(), (String)"visible", this.evaluateExpression(entry.getValue()));
                this.ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
            }
            catch (DDMExpressionException ddmExpressionException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)ddmExpressionException, (Throwable)ddmExpressionException);
            }
        }
    }

    protected void evaluateVisibilityExpressions() {
        Collection<DDMFormField> ddmFormFields = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> ddmFormFieldsStream = ddmFormFields.stream();
        Map<String, String> nameVisibilityExpressionMap = ddmFormFieldsStream.filter(field -> Validator.isNotNull((String)field.getVisibilityExpression())).collect(Collectors.toMap(field -> field.getName(), field -> field.getVisibilityExpression()));
        this.forEachEntry(nameVisibilityExpressionMap, this::evaluateVisibilityExpression);
    }

    protected boolean fieldsWithValidations(DDMFormField ddmFormField) {
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        if (ddmFormFieldValidation == null) {
            return false;
        }
        return Validator.isNotNull((Object)ddmFormFieldValidation.getDDMFormFieldValidationExpression());
    }

    protected boolean filterVisibleFieldsMarkedAsRequired(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        if (!this.getBooleanPropertyValue(ddmFormFieldContextKey, "required", false)) {
            return false;
        }
        return this.getBooleanPropertyValue(ddmFormFieldContextKey, "visible", true);
    }

    protected <K, V> void forEachEntry(Map<K, V> map, Consumer<Map.Entry<K, V>> entryConsumer) {
        Set<Map.Entry<K, V>> set = map.entrySet();
        Stream stream = set.stream();
        stream.forEach(entryConsumer);
    }

    protected boolean getBooleanPropertyValue(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey, String booleanPropertyName, boolean defaultValue) {
        Map changedProperties = this._ddmFormFieldsPropertyChanges.getOrDefault(ddmFormFieldContextKey, Collections.emptyMap());
        if (changedProperties.containsKey(booleanPropertyName)) {
            return MapUtil.getBoolean(changedProperties, (String)booleanPropertyName);
        }
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldContextKey.getName());
        return GetterUtil.getBoolean((Object)ddmFormField.getProperty(booleanPropertyName), (boolean)defaultValue);
    }

    protected Map<DDMFormEvaluatorFieldContextKey, Map<String, Object>> getDDMFormFieldsPropertyChanges() {
        return this._ddmFormFieldsPropertyChanges;
    }

    protected DDMFormFieldValidation getDDMFormFieldValidation(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormEvaluatorFieldContextKey.getName());
        return ddmFormField.getDDMFormFieldValidation();
    }

    protected DDMFormFieldValueAccessor<?> getDDMFormFieldValueAccessor(String type) {
        DDMFormFieldValueAccessor ddmFormFieldValueAccessor = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueAccessor(type);
        if (ddmFormFieldValueAccessor != null) {
            return ddmFormFieldValueAccessor;
        }
        return this.defaultDDMFormFieldValueAccessor;
    }

    protected Set<Integer> getDisabledPagesIndexes() {
        HashSet<Integer> disabledPagesIndexes = new HashSet<Integer>();
        for (Map.Entry<Integer, Integer> entry : this._pageFlow.entrySet()) {
            int fromPageIndex = entry.getKey();
            int toPageIndex = entry.getValue();
            for (int i = fromPageIndex + 1; i < toPageIndex; ++i) {
                disabledPagesIndexes.add(i);
            }
        }
        return disabledPagesIndexes;
    }

    protected boolean isFieldEmpty(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        DDMFormField ddmFormField;
        DDMFormFieldValueAccessor<?> ddmFormFieldValueAccessor;
        DDMFormFieldValue ddmFormFieldValue = this._ddmFormEvaluatorFormValuesHelper.getDDMFormFieldValue(ddmFormFieldContextKey);
        if (ddmFormFieldValue == null) {
            return true;
        }
        Object value = this.ddmFormEvaluatorDDMExpressionFieldAccessor.getFieldPropertyChanged(ddmFormFieldContextKey, "value");
        if (value != null) {
            this.updateDDMFormFieldValue(ddmFormFieldValue, value);
        }
        return (ddmFormFieldValueAccessor = this.getDDMFormFieldValueAccessor((ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldContextKey.getName())).getType())).isEmpty(ddmFormFieldValue, this._ddmFormEvaluatorEvaluateRequest.getLocale());
    }

    protected boolean isFieldNative(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        return this.getBooleanPropertyValue(ddmFormFieldContextKey, "nativeField", true);
    }

    protected boolean isFieldReadOnly(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        return this.getBooleanPropertyValue(ddmFormEvaluatorFieldContextKey, "readOnly", false);
    }

    protected boolean isFieldVisible(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        Map<String, Object> ddmFormFieldPropertyChanges = this._ddmFormFieldsPropertyChanges.get(ddmFormFieldContextKey);
        if (ddmFormFieldPropertyChanges == null) {
            return true;
        }
        return GetterUtil.get((Object)ddmFormFieldPropertyChanges.get("visible"), (boolean)true);
    }

    protected void setRequiredErrorMessage(DDMFormEvaluatorFieldContextKey fieldContextKey) {
        UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)fieldContextKey.getName(), (String)"errorMessage", (Object)LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"this-field-is-required"));
        builder.withInstanceId(fieldContextKey.getInstanceId()).withParameter("valid", (Object)false);
        this.ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
    }

    protected void updateDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Object newValue) {
        DDMForm ddmForm;
        Set availableLocales;
        Value value = ddmFormFieldValue.getValue();
        Locale locale = value.getDefaultLocale();
        if (value.isLocalized() && (availableLocales = (ddmForm = this._ddmFormEvaluatorEvaluateRequest.getDDMForm()).getAvailableLocales()).contains(this._ddmFormEvaluatorEvaluateRequest.getLocale())) {
            locale = this._ddmFormEvaluatorEvaluateRequest.getLocale();
        }
        value.addString(locale, String.valueOf(newValue));
    }

    protected void validateField(Map.Entry<DDMFormEvaluatorFieldContextKey, DDMFormFieldValidation> entry) {
        boolean valid;
        String fieldInstanceId;
        String fieldName;
        DDMFormFieldValidation ddmFormFieldValidation;
        block11: {
            DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey = entry.getKey();
            if (this.isFieldEmpty(ddmFormEvaluatorFieldContextKey)) {
                return;
            }
            if (this.isFieldReadOnly(ddmFormEvaluatorFieldContextKey)) {
                return;
            }
            if (!this.isFieldVisible(ddmFormEvaluatorFieldContextKey)) {
                return;
            }
            ddmFormFieldValidation = entry.getValue();
            if (ddmFormFieldValidation == null) {
                return;
            }
            DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
            if (Validator.isNull((String)ddmFormFieldValidationExpression.getValue())) {
                return;
            }
            fieldName = ddmFormEvaluatorFieldContextKey.getName();
            fieldInstanceId = ddmFormEvaluatorFieldContextKey.getInstanceId();
            valid = false;
            try {
                String localizedValueString = null;
                LocalizedValue parameterLocalizedValue = ddmFormFieldValidation.getParameterLocalizedValue();
                if (parameterLocalizedValue != null && Validator.isNull((String)(localizedValueString = parameterLocalizedValue.getString(this._resourceBundle.getLocale())))) {
                    localizedValueString = parameterLocalizedValue.getString(parameterLocalizedValue.getDefaultLocale());
                }
                DDMExpression ddmExpression = null;
                ddmExpression = Validator.isNull(localizedValueString) ? this.createExpression(ddmFormFieldValidationExpression.getValue()) : this.createExpression(StringUtil.replace((String)ddmFormFieldValidationExpression.getValue(), (String)"{parameter}", (String)localizedValueString));
                GetFieldPropertyRequest.Builder builder = GetFieldPropertyRequest.Builder.newBuilder((String)fieldName, (String)"value");
                builder.withInstanceId(fieldInstanceId);
                GetFieldPropertyResponse getFieldPropertyResponse = this.ddmFormEvaluatorDDMExpressionFieldAccessor.getFieldProperty(builder.build());
                ddmExpression.setVariable(fieldName, getFieldPropertyResponse.getValue());
                valid = (Boolean)ddmExpression.evaluate();
            }
            catch (DDMExpressionException ddmExpressionException) {
                if (!_log.isDebugEnabled()) break block11;
                _log.debug((Object)ddmExpressionException, (Throwable)ddmExpressionException);
            }
        }
        UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)fieldName, (String)"valid", (Object)valid);
        builder.withInstanceId(fieldInstanceId);
        if (!valid) {
            String errorMessage = null;
            LocalizedValue errorMessageLocalizedValue = ddmFormFieldValidation.getErrorMessageLocalizedValue();
            if (errorMessageLocalizedValue != null) {
                errorMessage = errorMessageLocalizedValue.getString(this._resourceBundle.getLocale());
            }
            if (errorMessage == null) {
                errorMessage = LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"this-field-is-invalid");
            }
            builder.withParameter("errorMessage", (Object)errorMessage);
        }
        this.ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
    }

    protected void validateFields() {
        Collection<DDMFormField> ddmFormFields = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> ddmFormFieldsStream = ddmFormFields.stream();
        Map ddmFormFieldValidations = ddmFormFieldsStream.filter(this::fieldsWithValidations).flatMap(ddmFormField -> this._getDDMFormEvaluatorFieldContextKey(ddmFormField.getName())).collect(Collectors.toMap(Function.identity(), this::getDDMFormFieldValidation));
        this.forEachEntry(ddmFormFieldValidations, this::validateField);
    }

    protected void verifyFieldsMarkedAsRequired() {
        Set<Map.Entry<String, DDMFormField>> entrySet = this._ddmFormFieldsMap.entrySet();
        Stream stream = entrySet.stream();
        stream.flatMap(entry -> this._getDDMFormEvaluatorFieldContextKey((String)entry.getKey())).filter(this::filterVisibleFieldsMarkedAsRequired).filter(this::isFieldEmpty).forEach(this::setRequiredErrorMessage);
    }

    private Stream<DDMFormEvaluatorFieldContextKey> _getDDMFormEvaluatorFieldContextKey(String name) {
        Set<DDMFormEvaluatorFieldContextKey> ddmFormFieldContextKeySet = this._ddmFormEvaluatorFormValuesHelper.getDDMFormFieldContextKeySet(name);
        return ddmFormFieldContextKeySet.stream();
    }

    private boolean _isNumericField(DDMFormField ddmFormField) {
        String type = ddmFormField.getType();
        return type.equals("numeric");
    }

    private void _localizeDDMFormFieldValue(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        DDMFormFieldValue ddmFormFieldValue = this._ddmFormEvaluatorFormValuesHelper.getDDMFormFieldValue(ddmFormFieldContextKey);
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return;
        }
        this.forEachEntry(value.getValues(), entry -> {
            DDMFormFieldValueLocalizer ddmFormFieldValueLocalizer;
            if (Validator.isNotNull((String)((String)entry.getValue())) && (ddmFormFieldValueLocalizer = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueLocalizer(ddmFormFieldValue.getType())) != null) {
                if (ddmFormFieldValueLocalizer instanceof DDMFormFieldValueEditingAware) {
                    DDMFormFieldValueEditingAware ddmFormFieldValueEditingAware = (DDMFormFieldValueEditingAware)ddmFormFieldValueLocalizer;
                    ddmFormFieldValueEditingAware.setEditingFieldValue(this._ddmFormEvaluatorEvaluateRequest.isEditingFieldValue());
                }
                value.addString((Locale)entry.getKey(), ddmFormFieldValueLocalizer.localize((String)entry.getValue(), (Locale)entry.getKey()));
            }
        });
    }

    private void _localizeNumericDDMFormFieldValues() {
        Collection<DDMFormField> ddmFormFields = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> stream = ddmFormFields.stream();
        stream.filter(this::_isNumericField).flatMap(ddmFormField -> this._getDDMFormEvaluatorFieldContextKey(ddmFormField.getName())).forEach(this::_localizeDDMFormFieldValue);
    }

    private void _resetInvisibleFieldValue() {
        this._ddmFormFieldsPropertyChanges.forEach((ddmFormFieldContextKey, ddmFormFieldProperties) -> {
            if (this._ddmFormEvaluatorEvaluateRequest.isViewMode() && this._ddmFormEvaluatorEvaluateRequest.isEditingFieldValue() && !this.isFieldNative((DDMFormEvaluatorFieldContextKey)ddmFormFieldContextKey) && !this.isFieldVisible((DDMFormEvaluatorFieldContextKey)ddmFormFieldContextKey)) {
                ddmFormFieldProperties.put("value", "");
            }
        });
    }
}

