/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.function.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateFunctionsUtil {
    private static final Log _log = LogFactoryUtil.getLog(DateFunctionsUtil.class);

    public static Boolean isFutureDate(String dateString, Locale locale, String timeZoneId, String type) {
        LocalDate localDate;
        if (StringUtil.equals((String)type, (String)"responseDate") && (localDate = DateFunctionsUtil._getParsedLocalDate(dateString, locale)).isBefore(DateFunctionsUtil._getCurrentLocalDate(timeZoneId))) {
            return false;
        }
        return true;
    }

    public static Boolean isPastDate(String dateString, Locale locale, String timeZoneId, String type) {
        LocalDate localDate;
        if (StringUtil.equals((String)type, (String)"responseDate") && (localDate = DateFunctionsUtil._getParsedLocalDate(dateString, locale)).isAfter(DateFunctionsUtil._getCurrentLocalDate(timeZoneId))) {
            return false;
        }
        return true;
    }

    private static LocalDate _getCurrentLocalDate(String timeZoneId) {
        if (Validator.isNull((String)timeZoneId)) {
            TimeZone timeZone = TimeZoneUtil.getDefault();
            timeZoneId = timeZone.getID();
        }
        return LocalDate.now(ZoneId.of(timeZoneId));
    }

    private static LocalDate _getParsedLocalDate(String dateString, Locale locale) {
        try {
            Date date = DateUtil.parseDate((String)"yyyy-MM-dd", (String)dateString, (Locale)locale);
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            return zonedDateTime.toLocalDate();
        }
        catch (ParseException parseException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)parseException, (Throwable)parseException);
            }
            return LocalDate.parse(dateString, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
    }
}

