/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.expression;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionActionHandler;
import com.liferay.dynamic.data.mapping.expression.ExecuteActionRequest;
import com.liferay.dynamic.data.mapping.expression.ExecuteActionResponse;
import java.util.Map;
import java.util.Set;

public class DDMFormEvaluatorExpressionActionHandler
implements DDMExpressionActionHandler {
    private final Set<Integer> _disabledPageIndexes;
    private final Map<Integer, Integer> _pageFlow;

    public DDMFormEvaluatorExpressionActionHandler(Map<Integer, Integer> pageFlow, Set<Integer> disabledPageIndexes) {
        this._pageFlow = pageFlow;
        this._disabledPageIndexes = disabledPageIndexes;
    }

    public ExecuteActionResponse executeAction(ExecuteActionRequest executeActionRequest) {
        String action = executeActionRequest.getAction();
        if (action.equals("jumpPage")) {
            return this._jumpPage(executeActionRequest);
        }
        ExecuteActionResponse.Builder builder = ExecuteActionResponse.Builder.newBuilder((boolean)false);
        return builder.build();
    }

    private boolean _hasIntervalOnPageFlow(Integer fromPageIndex, Integer toPageIndex) {
        for (Map.Entry<Integer, Integer> entry : this._pageFlow.entrySet()) {
            int fromPageFlowIndex = entry.getKey();
            int toPageFlowIndex = entry.getValue();
            if (toPageIndex < fromPageFlowIndex || fromPageIndex > toPageFlowIndex || !this._disabledPageIndexes.contains(toPageIndex)) continue;
            return true;
        }
        return false;
    }

    private ExecuteActionResponse _jumpPage(ExecuteActionRequest executeActionRequest) {
        Integer from = (Integer)executeActionRequest.getParameter("from");
        Integer to = (Integer)executeActionRequest.getParameter("to");
        if (from != null && to != null && !this._hasIntervalOnPageFlow(from, to)) {
            this._pageFlow.put(from, to);
        }
        ExecuteActionResponse.Builder builder = ExecuteActionResponse.Builder.newBuilder((boolean)true);
        return builder.build();
    }
}

