/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.helper;

import com.liferay.dynamic.data.mapping.expression.UpdateFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionObserver;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import java.util.Map;
import java.util.Objects;

public class DDMFormEvaluatorRuleHelper {
    private final DDMFormEvaluatorExpressionObserver _ddmFormEvaluatorExpressionObserver;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;

    public DDMFormEvaluatorRuleHelper(Map<String, DDMFormField> ddmFormFieldsMap, DDMFormEvaluatorExpressionObserver ddmFormEvaluatorExpressionObserver) {
        this._ddmFormFieldsMap = ddmFormFieldsMap;
        this._ddmFormEvaluatorExpressionObserver = ddmFormEvaluatorExpressionObserver;
    }

    public void checkFieldAffectedByAction(DDMFormRule ddmFormRule) {
        for (DDMFormField ddmFormField : this._ddmFormFieldsMap.values()) {
            this.checkFieldAffectedByAction(ddmFormRule, ddmFormField);
        }
    }

    protected void checkFieldAffectedByAction(DDMFormRule ddmFormRule, DDMFormField ddmFormField) {
        this._checkFieldAffectedBySetReadOnlyAction(ddmFormRule, ddmFormField);
        this._checkFieldAffectedBySetRequiredAction(ddmFormRule, ddmFormField);
        this._checkFieldAffectedBySetVisibleAction(ddmFormRule, ddmFormField);
    }

    private void _checkFieldAffectedBySetReadOnlyAction(DDMFormRule ddmFormRule, DDMFormField ddmFormField) {
        if (this._containsAction(ddmFormRule, "setEnabled", ddmFormField.getName(), !ddmFormField.isReadOnly())) {
            UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)ddmFormField.getName(), (String)"readOnly", (Object)(!ddmFormField.isReadOnly() ? 1 : 0));
            this._ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
        }
    }

    private void _checkFieldAffectedBySetRequiredAction(DDMFormRule ddmFormRule, DDMFormField ddmFormField) {
        if (this._containsAction(ddmFormRule, "setRequired", ddmFormField.getName(), ddmFormField.isRequired())) {
            UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)ddmFormField.getName(), (String)"required", (Object)(!ddmFormField.isRequired() ? 1 : 0));
            this._ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
        }
    }

    private void _checkFieldAffectedBySetVisibleAction(DDMFormRule ddmFormRule, DDMFormField ddmFormField) {
        if (this._containsAction(ddmFormRule, "setVisible", ddmFormField.getName(), true)) {
            UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)ddmFormField.getName(), (String)"visible", (Object)false);
            this._ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
        }
    }

    private boolean _containsAction(DDMFormRule ddmFormRule, String functionName, String ddmFormFieldName, boolean defaultValue) {
        String setBooleanPropertyAction = String.format("%s('%s', %s)", functionName, ddmFormFieldName, defaultValue);
        for (String action : ddmFormRule.getActions()) {
            if (!Objects.equals(setBooleanPropertyAction, action)) continue;
            return true;
        }
        return false;
    }
}

