/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DDMFormTemplateContextFactoryHelper {
    public Set<String> getEvaluableDDMFormFieldNames(DDMForm ddmForm, DDMFormLayout ddmFormLayout) {
        HashSet<String> evaluableDDMFormFieldNames = new HashSet<String>();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Set<String> ddmFormFieldNames = ddmFormFieldsMap.keySet();
        List ddmFormRules = ddmFormLayout.getDDMFormRules();
        if (ListUtil.isEmpty((List)ddmFormRules)) {
            ddmFormRules = ddmForm.getDDMFormRules();
        }
        evaluableDDMFormFieldNames.addAll(this.getReferencedFieldNamesByDDMFormRules(ddmFormRules, ddmFormFieldNames));
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            if (this.isDDMFormFieldEvaluable(ddmFormField)) {
                evaluableDDMFormFieldNames.add(ddmFormField.getName());
            }
            evaluableDDMFormFieldNames.addAll(this.getReferencedFieldNamesByExpression(ddmFormField.getVisibilityExpression(), ddmFormFieldNames));
        }
        return evaluableDDMFormFieldNames;
    }

    protected Set<String> getReferencedFieldNamesByDDMFormRules(List<DDMFormRule> ddmFormRules, Set<String> ddmFormFieldNames) {
        HashSet<String> referencedFieldNames = new HashSet<String>();
        for (DDMFormRule ddmFormRule : ddmFormRules) {
            referencedFieldNames.addAll(this.getReferencedFieldNamesByExpression(ddmFormRule.getCondition(), ddmFormFieldNames));
            for (String action : ddmFormRule.getActions()) {
                referencedFieldNames.addAll(this.getReferencedFieldNamesByExpression(action, ddmFormFieldNames));
            }
        }
        return referencedFieldNames;
    }

    protected Set<String> getReferencedFieldNamesByExpression(String expression, Set<String> ddmFormFieldNames) {
        if (Validator.isNull((String)expression)) {
            return Collections.emptySet();
        }
        HashSet<String> referencedFieldNames = new HashSet<String>();
        for (String ddmFormFieldName : ddmFormFieldNames) {
            Pattern pattern = Pattern.compile(String.format(".*('?%s'?).*", ddmFormFieldName));
            Matcher matcher = pattern.matcher(expression);
            if (!matcher.find()) continue;
            referencedFieldNames.add(ddmFormFieldName);
        }
        return referencedFieldNames;
    }

    protected boolean isDDMFormFieldEvaluable(DDMFormField ddmFormField) {
        if (this._getBooleanPropertyValue(ddmFormField, "inputMask") || this._getBooleanPropertyValue(ddmFormField, "requireConfirmation") || this._getBooleanPropertyValue(ddmFormField, "required")) {
            return true;
        }
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        return ddmFormFieldValidation != null && ddmFormFieldValidation.getDDMFormFieldValidationExpression() != null;
    }

    private boolean _getBooleanPropertyValue(DDMFormField ddmFormField, String propertyName) {
        return GetterUtil.getBoolean((Object)ddmFormField.getProperty(propertyName));
    }
}

