/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.Optional;

public class DefaultDDMFormValuesFactory {
    private final DDMForm _ddmForm;

    public DefaultDDMFormValuesFactory(DDMForm ddmForm) {
        this._ddmForm = ddmForm;
    }

    public DDMFormValues create() {
        DDMFormValues ddmFormValues = new DDMFormValues(this._ddmForm);
        ddmFormValues.setAvailableLocales(this._ddmForm.getAvailableLocales());
        ddmFormValues.setDefaultLocale(this._ddmForm.getDefaultLocale());
        for (DDMFormField ddmFormField : this._ddmForm.getDDMFormFields()) {
            DDMFormFieldValue ddmFormFieldValue = this.createDefaultDDMFormFieldValue(ddmFormField);
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    protected DDMFormFieldValue createDefaultDDMFormFieldValue(DDMFormField ddmFormField) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setFieldReference(ddmFormField.getFieldReference());
        ddmFormFieldValue.setName(ddmFormField.getName());
        ddmFormFieldValue.setValue(this.createDefaultValue(ddmFormField));
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDefaultDDMFormFieldValue(nestedDDMFormField));
        }
        return ddmFormFieldValue;
    }

    protected LocalizedValue createDefaultLocalizedValue(String defaultValueString) {
        LocalizedValue value = new LocalizedValue(this._ddmForm.getDefaultLocale());
        value.addString(this._ddmForm.getDefaultLocale(), defaultValueString);
        return value;
    }

    protected Value createDefaultValue(DDMFormField ddmFormField) {
        LocalizedValue defaultValue = ddmFormField.getPredefinedValue();
        if (defaultValue == null || MapUtil.isEmpty((Map)defaultValue.getValues())) {
            defaultValue = Optional.ofNullable((LocalizedValue)ddmFormField.getProperty("initialValue")).orElse(this.createDefaultLocalizedValue(""));
        }
        if (ddmFormField.isLocalizable()) {
            return defaultValue;
        }
        return new UnlocalizedValue(GetterUtil.getString((String)defaultValue.getString(this._ddmForm.getDefaultLocale())));
    }
}

