Liferay.Loader.define("dynamic-data-mapping-form-web@3.0.77/admin/js/components/ShareFormModal/Email.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-multi-select', 'dynamic-data-mapping-form-renderer/js/util/fetch.es', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _clayMultiSelect = _interopRequireDefault(require("frontend-taglib-clay$clay-multi-select"));

    var _fetch = require("dynamic-data-mapping-form-renderer/js/util/fetch.es");

    var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

    var _metalState = require("frontend-js-metal-web$metal-state");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var Email = /*#__PURE__*/function (_Component) {
      _inherits(Email, _Component);

      function Email() {
        _classCallCheck(this, Email);

        return _possibleConstructorReturn(this, _getPrototypeOf(Email).apply(this, arguments));
      }

      _createClass(Email, [{
        key: "created",
        value: function created() {
          this._fetchAutocompleteUser();
        }
      }, {
        key: "init",
        value: function init() {
          this.setState({
            emailContent: this._emailContentValueFn()
          });
        }
      }, {
        key: "isEmailAddressValid",
        value: function isEmailAddressValid(email) {
          var emailRegex = /.+@.+\..+/i;
          return emailRegex.test(email);
        }
      }, {
        key: "render",
        value: function render() {
          var _this$state = this.state,
              autocompleteUser = _this$state.autocompleteUser,
              emailContent = _this$state.emailContent;
          IncrementalDOM.elementOpen("div", null, null, "class", "share-form-modal-item-email");
          iDOMHelpers.renderArbitrary(autocompleteUser && IncrementalDOM.elementVoid(_clayMultiSelect.default, null, null, "dataSource", autocompleteUser, "events", {
            inputChange: this._handleInputChange.bind(this),
            labelItemAdded: this._handleLabelItemAdded.bind(this),
            labelItemRemoved: this._handleLabelItemRemoved.bind(this)
          }, "helpText", Liferay.Language.get('you-can-use-a-comma-to-enter-multiple-emails'), "label", Liferay.Language.get('to'), "placeholder", Liferay.Language.get('enter-a-list-of-email-addresses'), "selectedItems", emailContent.addresses, "spritemap", this.props.spritemap, "autocompleteFilterCondition", "value", "ref", 'multiSelectRef', "showSelectButton", false));
          IncrementalDOM.elementOpen("div", null, null, "class", "form-group");
          IncrementalDOM.elementOpen("label", null, null, "for", "subject");
          iDOMHelpers.renderArbitrary(Liferay.Language.get('subject'));
          IncrementalDOM.elementClose("label");
          IncrementalDOM.elementOpen("div", null, null, "class", "input-group");
          IncrementalDOM.elementOpen("div", null, null, "class", "input-group-item");
          IncrementalDOM.elementVoid("input", null, null, "data-oninput", this._handleSubjectChanged.bind(this), "value", emailContent.subject, "class", "form-control", "id", "subject", "type", "text");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementOpen("div", null, null, "class", "form-group");
          IncrementalDOM.elementOpen("label", null, null, "for", "message");
          iDOMHelpers.renderArbitrary(Liferay.Language.get('message'));
          IncrementalDOM.elementClose("label");
          IncrementalDOM.elementOpen("div", null, null, "class", "input-group");
          IncrementalDOM.elementOpen("div", null, null, "class", "input-group-item");
          IncrementalDOM.elementOpen("textarea", null, null, "data-oninput", this._handleMessageChanged.bind(this), "class", "form-control", "id", "message", "type", "text");
          iDOMHelpers.renderArbitrary(emailContent.message);
          IncrementalDOM.elementClose("textarea");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("div");
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "_autocompleteUserValueFn",
        value: function _autocompleteUserValueFn() {
          var autocompleteUser = this.props.autocompleteUser;
          return autocompleteUser;
        }
      }, {
        key: "_emailContentValueFn",
        value: function _emailContentValueFn() {
          return {
            addresses: [],
            message: Liferay.Util.sub(Liferay.Language.get('please-fill-out-this-form-x'), this.props.url),
            subject: this.props.localizedName[themeDisplay.getLanguageId()]
          };
        }
      }, {
        key: "_fetchAutocompleteUser",
        value: function _fetchAutocompleteUser() {
          var _this = this;

          var autocompleteUserURL = this.props.autocompleteUserURL;
          (0, _fetch.makeFetch)({
            method: 'GET',
            url: autocompleteUserURL
          }).then(function (responseData) {
            if (!_this.isDisposed()) {
              _this.setState({
                autocompleteUser: responseData.map(function (data) {
                  return {
                    label: data.emailAddress,
                    value: _this._getAutoCompleteValue(data)
                  };
                })
              });
            }
          }).catch(function (error) {
            throw new Error(error);
          });
        }
      }, {
        key: "_getAutoCompleteValue",
        value: function _getAutoCompleteValue(data) {
          return data.fullName + ' (' + data.emailAddress + ')';
        }
      }, {
        key: "_handleInputChange",
        value: function _handleInputChange(event) {
          var value = event.data.value;

          if (this.isEmailAddressValid(value)) {
            this.refs.multiSelectRef.creatable = true;
          } else {
            this.refs.multiSelectRef.creatable = false;
          }
        }
      }, {
        key: "_handleLabelItemAdded",
        value: function _handleLabelItemAdded(event) {
          var selectedItems = event.data.selectedItems;
          var emailContent = this.state.emailContent;
          this.setState({
            emailContent: _objectSpread(_objectSpread({}, emailContent), {}, {
              addresses: selectedItems
            })
          });
        }
      }, {
        key: "_handleLabelItemRemoved",
        value: function _handleLabelItemRemoved(event) {
          var selectedItems = event.data.selectedItems;
          var emailContent = this.state.emailContent;
          this.setState({
            emailContent: _objectSpread(_objectSpread({}, emailContent), {}, {
              addresses: selectedItems
            })
          });
        }
      }, {
        key: "_handleMessageChanged",
        value: function _handleMessageChanged(event) {
          var value = event.target.value;
          var emailContent = this.state.emailContent;
          this.setState({
            emailContent: _objectSpread(_objectSpread({}, emailContent), {}, {
              message: value
            })
          });
        }
      }, {
        key: "_handleSubjectChanged",
        value: function _handleSubjectChanged(event) {
          var value = event.target.value;
          var emailContent = this.state.emailContent;
          this.setState({
            emailContent: _objectSpread(_objectSpread({}, emailContent), {}, {
              subject: value
            })
          });
        }
      }]);

      return Email;
    }(_metalJsx.default);

    Email.PROPS = {
      /**
       * @default undefined
       * @instance
       * @memberof Email
       * @type {!string}
       */
      autocompleteUserURL: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof Email
       * @type {!object}
       */
      localizedName: _metalState.Config.object(),

      /**
       * @default undefined
       * @instance
       * @memberof Email
       * @type {!spritemap}
       */
      spritemap: _metalState.Config.string().required()
    };
    Email.STATE = {
      /**
       * @default _autocompleteUserValueFn
       * @instance
       * @memberof Email
       * @type {!array}
       */
      autocompleteUser: _metalState.Config.array().valueFn('_autocompleteUserValueFn'),

      /**
       * @default undefined
       * @instance
       * @memberof Email
       * @type {!array}
       */
      emailContent: _metalState.Config.object().valueFn('_emailContentValueFn')
    };
    var _default = Email;
    exports.default = _default;
    //# sourceMappingURL=Email.es.js.map
  }
});
//# sourceMappingURL=Email.es.js.map