Liferay.Loader.define("dynamic-data-mapping-form-web@3.0.77/admin/js/util/AutoSave.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/fetch.es', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', 'dynamic-data-mapping-form-web$object-hash'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _fetch = require("dynamic-data-mapping-form-renderer/js/util/fetch.es");

    var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

    var _metalState = require("frontend-js-metal-web$metal-state");

    var _objectHash = _interopRequireDefault(require("dynamic-data-mapping-form-web$object-hash"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _get(target, property, receiver) {
      if (typeof Reflect !== "undefined" && Reflect.get) {
        _get = Reflect.get;
      } else {
        _get = function _get(target, property, receiver) {
          var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
            return desc.get.call(receiver);
          }return desc.value;
        };
      }return _get(target, property, receiver || target);
    }

    function _superPropBase(object, property) {
      while (!Object.prototype.hasOwnProperty.call(object, property)) {
        object = _getPrototypeOf(object);if (object === null) break;
      }return object;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var AutoSave = /*#__PURE__*/function (_Component) {
      _inherits(AutoSave, _Component);

      function AutoSave() {
        _classCallCheck(this, AutoSave);

        return _possibleConstructorReturn(this, _getPrototypeOf(AutoSave).apply(this, arguments));
      }

      _createClass(AutoSave, [{
        key: "created",
        value: function created() {
          var currentState = this.getCurrentState();
          var currentStateHash = this.getStateHash(currentState);
          this._lastKnownHash = currentStateHash;
          this.start();
        }
      }, {
        key: "disposeInternal",
        value: function disposeInternal() {
          _get(_getPrototypeOf(AutoSave.prototype), "disposeInternal", this).call(this);

          this.stop();
        }
      }, {
        key: "getCurrentState",
        value: function getCurrentState() {
          var stateSyncronizer = this.props.stateSyncronizer;
          return stateSyncronizer.getState();
        }
      }, {
        key: "getStateHash",
        value: function getStateHash(state) {
          return (0, _objectHash.default)(state, {
            algorithm: 'md5',
            unorderedObjects: true
          });
        }
      }, {
        key: "hasUnsavedChanges",
        value: function hasUnsavedChanges() {
          var currentState = this.getCurrentState();
          var currentStateHash = this.getStateHash(currentState);
          return this._lastKnownHash !== currentStateHash;
        }
      }, {
        key: "save",
        value: function save() {
          var _this = this;

          var saveAsDraft = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props.saveAsDraft;
          var stateSyncronizer = this.props.stateSyncronizer;
          var currentState = this.getCurrentState();
          stateSyncronizer.syncInputs();
          this._pendingRequest = (0, _fetch.makeFetch)({
            body: this._getFormData(saveAsDraft),
            url: this.props.url
          }).then(function (responseData) {
            _this._pendingRequest = null;

            _this._defineIds(responseData);

            _this.saveStateHash(currentState);

            _this.emit('autosaved', {
              modifiedDate: responseData.modifiedDate,
              savedAsDraft: saveAsDraft
            });

            return responseData;
          }).catch(function (reason) {
            _this._pendingRequest = null;
            throw reason;
          });
          return this._pendingRequest;
        }
      }, {
        key: "saveIfNeeded",
        value: function saveIfNeeded() {
          var _this2 = this;

          if (!this.isDisposed()) {
            var stateSyncronizer = this.props.stateSyncronizer;

            if (this._pendingRequest) {
              this._pendingRequest.then(function () {
                return _this2.saveIfNeeded();
              }).catch(function () {});
            } else if (this.hasUnsavedChanges() && !stateSyncronizer.isEmpty()) {
              this.save();
            }
          }
        }
      }, {
        key: "saveStateHash",
        value: function saveStateHash(state) {
          this._lastKnownHash = this.getStateHash(state);
        }
      }, {
        key: "start",
        value: function start() {
          var _this3 = this;

          var interval = this.props.interval;
          this.stop();

          if (interval > 0) {
            this._intervalId = setInterval(function () {
              return _this3.saveIfNeeded();
            }, interval);
          }
        }
      }, {
        key: "stop",
        value: function stop() {
          if (this._intervalId) {
            clearInterval(this._intervalId);
          }
        }
      }, {
        key: "_defineIds",
        value: function _defineIds(response) {
          var namespace = this.props.namespace;
          var formInstanceIdNode = document.querySelector("#".concat(namespace, "formInstanceId"));

          if (formInstanceIdNode && formInstanceIdNode.value === '0') {
            formInstanceIdNode.value = response.formInstanceId;
          }

          var ddmStructureIdNode = document.querySelector("#".concat(namespace, "ddmStructureId"));

          if (ddmStructureIdNode && ddmStructureIdNode.value === '0') {
            ddmStructureIdNode.value = response.ddmStructureId;
          }
        }
      }, {
        key: "_getFormData",
        value: function _getFormData(saveAsDraft) {
          var _this$props = this.props,
              form = _this$props.form,
              namespace = _this$props.namespace;
          var formData = new FormData(form);
          var state = this.getCurrentState();
          formData.append("".concat(namespace, "name"), JSON.stringify(state.name));
          formData.append("".concat(namespace, "published"), JSON.stringify(this.published));
          formData.append("".concat(namespace, "saveAsDraft"), saveAsDraft);
          return (0, _fetch.convertToFormData)(formData);
        }
      }, {
        key: "_setInterval",
        value: function _setInterval(minutes) {
          return minutes * 60000;
        }
      }]);

      return AutoSave;
    }(_metalJsx.default);

    AutoSave.PROPS = {
      form: _metalState.Config.any(),
      interval: _metalState.Config.number().setter('_setInterval'),
      saveAsDraft: _metalState.Config.bool().value(true),
      stateSyncronizer: _metalState.Config.any(),
      url: _metalState.Config.string()
    };
    var _default = AutoSave;
    exports.default = _default;
    //# sourceMappingURL=AutoSave.es.js.map
  }
});
//# sourceMappingURL=AutoSave.es.js.map