/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io.exporter;

import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterRequest;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterResponse;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.CSVUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"ddm.form.instance.record.writer.type=csv"}, service={DDMFormInstanceRecordWriter.class})
public class DDMFormInstanceRecordCSVWriter
implements DDMFormInstanceRecordWriter {
    public DDMFormInstanceRecordWriterResponse write(DDMFormInstanceRecordWriterRequest ddmFormInstanceRecordWriterRequest) throws Exception {
        StringBundler sb = new StringBundler(3);
        Map ddmFormFieldsLabel = ddmFormInstanceRecordWriterRequest.getDDMFormFieldsLabel();
        List<String> labels = this._getDistinctLabels(ddmFormFieldsLabel);
        sb.append(this.writeValues(labels));
        sb.append("\n");
        sb.append(this.writeRecords(ddmFormFieldsLabel, ddmFormInstanceRecordWriterRequest.getDDMFormFieldValues(), labels));
        String csv = sb.toString();
        DDMFormInstanceRecordWriterResponse.Builder builder = DDMFormInstanceRecordWriterResponse.Builder.newBuilder((byte[])csv.getBytes());
        return builder.build();
    }

    protected String writeRecord(Map<String, String> ddmFormFieldsLabel, Map<String, String> ddmFormFieldValue, List<String> labels) {
        Set<Map.Entry<String, String>> entrySet = ddmFormFieldsLabel.entrySet();
        Stream stream = entrySet.stream();
        return stream.filter(entry -> labels.contains(entry.getValue()) && ddmFormFieldValue.containsKey(entry.getKey())).map(entry -> CSVUtil.encode((String)((String)ddmFormFieldValue.get(entry.getKey())))).collect(Collectors.joining(","));
    }

    protected String writeRecords(Map<String, String> ddmFormFieldsLabel, List<Map<String, String>> ddmFormFieldsValue, List<String> labels) {
        Stream stream = ddmFormFieldsValue.stream();
        return stream.map(values -> this.writeRecord(ddmFormFieldsLabel, (Map<String, String>)values, labels)).collect(Collectors.joining("\n"));
    }

    protected String writeValues(Collection<String> values) {
        Stream<String> stream = values.stream();
        return stream.map(CSVUtil::encode).collect(Collectors.joining(","));
    }

    private List<String> _getDistinctLabels(Map<String, String> ddmFormFieldsLabel) {
        ArrayList<String> labels = new ArrayList<String>();
        for (String label : ddmFormFieldsLabel.values()) {
            if (labels.contains(label)) continue;
            labels.add(label);
        }
        return labels;
    }
}

