/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io.exporter;

import com.liferay.dynamic.data.mapping.exception.FormInstanceRecordExporterException;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordExporter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordExporterRequest;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordExporterResponse;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterRequest;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterResponse;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterTracker;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.comparator.FormInstanceVersionVersionComparator;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormInstanceRecordExporter.class})
public class DDMFormInstanceRecordExporterImpl
implements DDMFormInstanceRecordExporter {
    @Reference
    protected DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker;
    @Reference
    protected DDMFormInstanceRecordLocalService ddmFormInstanceRecordLocalService;
    @Reference
    protected DDMFormInstanceRecordWriterTracker ddmFormInstanceRecordWriterTracker;
    @Reference
    protected DDMFormInstanceVersionLocalService ddmFormInstanceVersionLocalService;
    private static final String _AUTHOR = "author";
    private static final String _MODIFIED_DATE = "modifiedDate";
    private static final String _STATUS = "status";

    public DDMFormInstanceRecordExporterResponse export(DDMFormInstanceRecordExporterRequest ddmFormInstanceRecordExporterRequest) throws FormInstanceRecordExporterException {
        long ddmFormInstanceId = ddmFormInstanceRecordExporterRequest.getDDMFormInstanceId();
        int status = ddmFormInstanceRecordExporterRequest.getStatus();
        int start = ddmFormInstanceRecordExporterRequest.getStart();
        int end = ddmFormInstanceRecordExporterRequest.getEnd();
        OrderByComparator orderByComparator = ddmFormInstanceRecordExporterRequest.getOrderByComparator();
        Locale locale = ddmFormInstanceRecordExporterRequest.getLocale();
        String type = ddmFormInstanceRecordExporterRequest.getType();
        DDMFormInstanceRecordExporterResponse.Builder builder = DDMFormInstanceRecordExporterResponse.Builder.newBuilder();
        try {
            List ddmFormInstanceRecords = this.ddmFormInstanceRecordLocalService.getFormInstanceRecords(ddmFormInstanceId, status, start, end, orderByComparator);
            Map<String, DDMFormField> ddmFormFields = this.getDistinctFields(ddmFormInstanceId);
            byte[] content = this.write(type, this.getDDMFormFieldsLabel(ddmFormFields, locale), this.getDDMFormFieldValues(ddmFormFields, ddmFormInstanceRecords, locale));
            builder = builder.withContent(content);
        }
        catch (Exception exception) {
            throw new FormInstanceRecordExporterException((Throwable)exception);
        }
        return builder.build();
    }

    protected Map<String, String> getDDMFormFieldsLabel(Map<String, DDMFormField> ddmFormFieldMap, Locale locale) {
        LinkedHashMap<String, String> ddmFormFieldsLabel = new LinkedHashMap<String, String>();
        Collection<DDMFormField> ddmFormFields = ddmFormFieldMap.values();
        Stream<DDMFormField> stream = ddmFormFields.stream();
        stream.forEach(field -> {
            LocalizedValue localizedValue = field.getLabel();
            ddmFormFieldsLabel.put(field.getName(), localizedValue.getString(locale));
        });
        ddmFormFieldsLabel.put(_STATUS, LanguageUtil.get((Locale)locale, (String)_STATUS));
        ddmFormFieldsLabel.put(_MODIFIED_DATE, LanguageUtil.get((Locale)locale, (String)"modified-date"));
        ddmFormFieldsLabel.put(_AUTHOR, LanguageUtil.get((Locale)locale, (String)_AUTHOR));
        return ddmFormFieldsLabel;
    }

    protected String getDDMFormFieldValue(DDMFormField ddmFormField, Map<String, List<DDMFormFieldValue>> ddmFormFieldValueMap, Locale locale) {
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValueMap.get(ddmFormField.getName());
        DDMFormFieldValueRenderer ddmFormFieldValueRenderer = this.ddmFormFieldTypeServicesTracker.getDDMFormFieldValueRenderer(ddmFormField.getType());
        Stream stream = ddmFormFieldValues.stream();
        return HtmlUtil.render((String)StringUtil.merge((Collection)stream.map(ddmForFieldValue -> ddmFormFieldValueRenderer.render(ddmForFieldValue, locale)).filter(Validator::isNotNull).collect(Collectors.toList()), (String)", "));
    }

    protected List<Map<String, String>> getDDMFormFieldValues(Map<String, DDMFormField> ddmFormFields, List<DDMFormInstanceRecord> ddmFormInstanceRecords, Locale locale) throws Exception {
        ArrayList<Map<String, String>> ddmFormFieldValues = new ArrayList<Map<String, String>>();
        Format dateTimeFormat = FastDateFormatFactoryUtil.getDateTime((Locale)locale);
        for (DDMFormInstanceRecord ddmFormInstanceRecord : ddmFormInstanceRecords) {
            DDMFormValues ddmFormValues = ddmFormInstanceRecord.getDDMFormValues();
            Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
            LinkedHashMap<String, String> ddmFormFieldsValue = new LinkedHashMap<String, String>();
            for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
                if (!ddmFormFieldValuesMap.containsKey(entry.getKey())) {
                    ddmFormFieldsValue.put(entry.getKey(), "");
                    continue;
                }
                ddmFormFieldsValue.put(entry.getKey(), this.getDDMFormFieldValue(entry.getValue(), ddmFormFieldValuesMap, locale));
            }
            DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = ddmFormInstanceRecord.getFormInstanceRecordVersion();
            ddmFormFieldsValue.put(_STATUS, this.getStatusMessage(ddmFormInstanceRecordVersion.getStatus(), locale));
            ddmFormFieldsValue.put(_MODIFIED_DATE, dateTimeFormat.format(ddmFormInstanceRecordVersion.getStatusDate()));
            ddmFormFieldsValue.put(_AUTHOR, ddmFormInstanceRecordVersion.getUserName());
            ddmFormFieldValues.add(ddmFormFieldsValue);
        }
        return ddmFormFieldValues;
    }

    protected Map<String, DDMFormField> getDistinctFields(long ddmFormInstanceId) throws Exception {
        List<DDMStructureVersion> ddmStructureVersions = this.getStructureVersions(ddmFormInstanceId);
        LinkedHashMap<String, DDMFormField> ddmFormFields = new LinkedHashMap<String, DDMFormField>();
        Stream stream = ddmStructureVersions.stream();
        stream.map(this::getNontransientDDMFormFieldsMap).forEach(map -> map.forEach((key, ddmFormField) -> ddmFormFields.putIfAbsent((String)key, (DDMFormField)ddmFormField)));
        return ddmFormFields;
    }

    protected Map<String, DDMFormField> getNontransientDDMFormFieldsMap(DDMStructureVersion ddmStructureVersion) {
        DDMForm ddmForm = ddmStructureVersion.getDDMForm();
        return ddmForm.getNontransientDDMFormFieldsMap(true);
    }

    protected String getStatusMessage(int status, Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)WorkflowConstants.getStatusLabel((int)status));
    }

    protected List<DDMStructureVersion> getStructureVersions(long ddmFormInstanceId) throws Exception {
        List ddmFormInstanceVersions = this.ddmFormInstanceVersionLocalService.getFormInstanceVersions(ddmFormInstanceId, -1, -1, null);
        ddmFormInstanceVersions = ListUtil.sort((List)ddmFormInstanceVersions, (Comparator)new FormInstanceVersionVersionComparator());
        ArrayList<DDMStructureVersion> ddmStructureVersions = new ArrayList<DDMStructureVersion>();
        for (DDMFormInstanceVersion ddmFormInstanceVersion : ddmFormInstanceVersions) {
            ddmStructureVersions.add(ddmFormInstanceVersion.getStructureVersion());
        }
        return ddmStructureVersions;
    }

    protected byte[] write(String type, Map<String, String> ddmFormFieldsLabel, List<Map<String, String>> ddmFormFieldValues) throws Exception {
        DDMFormInstanceRecordWriter ddmFormInstanceRecordWriter = this.ddmFormInstanceRecordWriterTracker.getDDMFormInstanceRecordWriter(type);
        DDMFormInstanceRecordWriterRequest.Builder builder = DDMFormInstanceRecordWriterRequest.Builder.newBuilder(ddmFormFieldsLabel, ddmFormFieldValues);
        DDMFormInstanceRecordWriterRequest ddmFormInstanceRecordWriterRequest = builder.build();
        DDMFormInstanceRecordWriterResponse ddmFormInstanceRecordWriterResponse = ddmFormInstanceRecordWriter.write(ddmFormInstanceRecordWriterRequest);
        return ddmFormInstanceRecordWriterResponse.getContent();
    }
}

