/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure"}, service={ModelDocumentContributor.class})
public class DDMStructureModelDocumentContributor
implements ModelDocumentContributor<DDMStructure> {
    @Reference
    protected DDMStructureVersionLocalService ddmStructureVersionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureModelDocumentContributor.class);
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;

    public void contribute(Document document, DDMStructure ddmStructure) {
        block5: {
            block4: {
                document.addKeyword("classNameId", ddmStructure.getClassNameId());
                document.addLocalizedText("description", LocalizationUtil.populateLocalizationMap((Map)ddmStructure.getDescriptionMap(), (String)ddmStructure.getDefaultLanguageId(), (long)ddmStructure.getGroupId()));
                document.addLocalizedText("name", LocalizationUtil.populateLocalizationMap((Map)ddmStructure.getNameMap(), (String)ddmStructure.getDefaultLanguageId(), (long)ddmStructure.getGroupId()));
                try {
                    DDMStructureVersion structureVersion = this.ddmStructureVersionLocalService.getStructureVersion(ddmStructure.getStructureId(), ddmStructure.getVersion());
                    document.addKeyword("status", structureVersion.getStatus());
                    document.addKeyword("version", structureVersion.getVersion());
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)pe, (Throwable)pe);
                }
            }
            try {
                document.addKeyword("resourcePermissionName", this._ddmPermissionSupport.getStructureModelResourceName(ddmStructure.getClassNameId()));
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        document.addKeyword("resourceClassNameId", ddmStructure.getClassNameId());
        document.addKeyword("structureKey", ddmStructure.getStructureKey());
        document.addKeyword("storageType", ddmStructure.getStorageType());
        document.addKeyword("type", ddmStructure.getType());
        document.addLocalizedKeyword("localized_name", LocalizationUtil.populateLocalizationMap((Map)ddmStructure.getNameMap(), (String)ddmStructure.getDefaultLanguageId(), (long)ddmStructure.getGroupId()), true, true);
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

