/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.storage.BaseFieldRenderer;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class DocumentLibraryFieldRenderer
extends BaseFieldRenderer {
    private static final Log _log = LogFactoryUtil.getLog(DocumentLibraryFieldRenderer.class);
    private final DLAppService _dlAppService;
    private final JSONFactory _jsonFactory;
    private final Language _language;

    protected DocumentLibraryFieldRenderer(DLAppService dlAppService, JSONFactory jsonFactory, Language language) {
        this._dlAppService = dlAppService;
        this._jsonFactory = jsonFactory;
        this._language = language;
    }

    protected String doRender(Field field, Locale locale) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        for (Serializable value : field.getValues(locale)) {
            String valueString = String.valueOf(value);
            if (Validator.isNull((String)valueString)) continue;
            values.add(this.handleJSON(valueString, locale));
        }
        return StringUtil.merge(values, (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        return this.handleJSON(String.valueOf(value), locale);
    }

    protected String handleJSON(String json, Locale locale) {
        JSONObject jsonObject = null;
        try {
            jsonObject = this._jsonFactory.createJSONObject(json);
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsone);
            }
            return "";
        }
        long fileEntryGroupId = jsonObject.getLong("groupId");
        String fileEntryUUID = jsonObject.getString("uuid");
        try {
            FileEntry fileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(fileEntryUUID, fileEntryGroupId);
            return fileEntry.getTitle();
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                return this._language.format(locale, "is-temporarily-unavailable", (Object)"content");
            }
            return "";
        }
    }
}

