/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw.geom;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.sl.draw.geom.AbsExpression;
import org.apache.poi.sl.draw.geom.AddDivideExpression;
import org.apache.poi.sl.draw.geom.AddSubtractExpression;
import org.apache.poi.sl.draw.geom.ArcTanExpression;
import org.apache.poi.sl.draw.geom.CosExpression;
import org.apache.poi.sl.draw.geom.CosineArcTanExpression;
import org.apache.poi.sl.draw.geom.Expression;
import org.apache.poi.sl.draw.geom.IfElseExpression;
import org.apache.poi.sl.draw.geom.LiteralValueExpression;
import org.apache.poi.sl.draw.geom.MaxExpression;
import org.apache.poi.sl.draw.geom.MinExpression;
import org.apache.poi.sl.draw.geom.ModExpression;
import org.apache.poi.sl.draw.geom.MultiplyDivideExpression;
import org.apache.poi.sl.draw.geom.PinExpression;
import org.apache.poi.sl.draw.geom.SinArcTanExpression;
import org.apache.poi.sl.draw.geom.SinExpression;
import org.apache.poi.sl.draw.geom.SqrtExpression;
import org.apache.poi.sl.draw.geom.TanExpression;

public class ExpressionParser {
    private static final Map<String, ExpressionEntry> impls = new HashMap<String, ExpressionEntry>();

    private static String op(String str) {
        return str == null || !str.contains(" ") ? "" : str.substring(0, str.indexOf(" ")).replace("\\", "");
    }

    public static Expression parse(String str) {
        Matcher m;
        ExpressionEntry ee = impls.get(ExpressionParser.op(str));
        Matcher matcher = m = ee == null ? null : ee.regex.matcher(str);
        if (m == null || !m.matches()) {
            throw new RuntimeException("Unsupported formula: " + str);
        }
        try {
            return ee.con.newInstance(m);
        }
        catch (Exception e) {
            throw new RuntimeException("Unsupported formula: " + str, e);
        }
    }

    static {
        try {
            new ExpressionEntry("\\*/ +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", MultiplyDivideExpression.class);
            new ExpressionEntry("\\+- +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)( 0)?", AddSubtractExpression.class);
            new ExpressionEntry("\\+/ +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", AddDivideExpression.class);
            new ExpressionEntry("\\?: +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", IfElseExpression.class);
            new ExpressionEntry("val +([\\-\\w]+)", LiteralValueExpression.class);
            new ExpressionEntry("abs +([\\-\\w]+)", AbsExpression.class);
            new ExpressionEntry("sqrt +([\\-\\w]+)", SqrtExpression.class);
            new ExpressionEntry("max +([\\-\\w]+) +([\\-\\w]+)", MaxExpression.class);
            new ExpressionEntry("min +([\\-\\w]+) +([\\-\\w]+)", MinExpression.class);
            new ExpressionEntry("at2 +([\\-\\w]+) +([\\-\\w]+)", ArcTanExpression.class);
            new ExpressionEntry("sin +([\\-\\w]+) +([\\-\\w]+)", SinExpression.class);
            new ExpressionEntry("cos +([\\-\\w]+) +([\\-\\w]+)", CosExpression.class);
            new ExpressionEntry("tan +([\\-\\w]+) +([\\-\\w]+)", TanExpression.class);
            new ExpressionEntry("cat2 +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", CosineArcTanExpression.class);
            new ExpressionEntry("sat2 +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", SinArcTanExpression.class);
            new ExpressionEntry("pin +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", PinExpression.class);
            new ExpressionEntry("mod +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", ModExpression.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ExpressionEntry {
        final Pattern regex;
        final Constructor<? extends Expression> con;

        ExpressionEntry(String regex, Class<? extends Expression> cls) throws SecurityException, NoSuchMethodException {
            this.regex = Pattern.compile(regex);
            this.con = cls.getDeclaredConstructor(Matcher.class);
            impls.put(ExpressionParser.op(regex), this);
        }
    }
}

