/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_5_0;

import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UpgradeDDMStructure
extends UpgradeProcess {
    private final DDMFormLayoutDeserializer _ddmFormLayoutDeserializer;
    private final DDMFormLayoutSerializer _ddmFormLayoutSerializer;

    public UpgradeDDMStructure(DDMFormLayoutDeserializer ddmFormLayoutDeserializer, DDMFormLayoutSerializer ddmFormLayoutSerializer) {
        this._ddmFormLayoutDeserializer = ddmFormLayoutDeserializer;
        this._ddmFormLayoutSerializer = ddmFormLayoutSerializer;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeStructureDefinition();
        this._upgradeStructureLayoutDefinition();
        this._upgradeStructureVersionDefinition();
    }

    private void _upgradeColorField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "color").put("visibilityExpression", "");
    }

    private void _upgradeDateField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "date").put("visibilityExpression", "");
    }

    private String _upgradeDDMFormLayoutDefinition(String content) {
        DDMFormLayoutDeserializerDeserializeResponse ddmFormLayoutDeserializerDeserializeResponse = this._ddmFormLayoutDeserializer.deserialize(DDMFormLayoutDeserializerDeserializeRequest.Builder.newBuilder((String)content).build());
        DDMFormLayout ddmFormLayout = ddmFormLayoutDeserializerDeserializeResponse.getDDMFormLayout();
        Set availableLocales = ddmFormLayout.getAvailableLocales();
        List ddmFormLayoutPages = ddmFormLayout.getDDMFormLayoutPages();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayoutPages) {
            LocalizedValue localizedValue = ddmFormLayoutPage.getTitle();
            if (localizedValue == null) {
                localizedValue = new LocalizedValue();
                localizedValue.addString(ddmFormLayout.getDefaultLocale(), LanguageUtil.get((Locale)ddmFormLayout.getDefaultLocale(), (String)"page"));
                for (Locale locale : availableLocales) {
                    localizedValue.addString(locale, LanguageUtil.get((Locale)locale, (String)"page"));
                }
            } else if (Validator.isNull((String)localizedValue.getString(ddmFormLayout.getDefaultLocale()))) {
                localizedValue.addString(ddmFormLayout.getDefaultLocale(), LanguageUtil.get((Locale)ddmFormLayout.getDefaultLocale(), (String)"page"));
            }
            ddmFormLayoutPage.setTitle(localizedValue);
            localizedValue = ddmFormLayoutPage.getDescription();
            if (localizedValue == null) {
                localizedValue = new LocalizedValue();
                localizedValue.addString(ddmFormLayout.getDefaultLocale(), LanguageUtil.get((Locale)ddmFormLayout.getDefaultLocale(), (String)"description"));
                for (Locale locale : availableLocales) {
                    localizedValue.addString(locale, LanguageUtil.get((Locale)locale, (String)"description"));
                }
            } else if (Validator.isNull((String)localizedValue.getString(ddmFormLayout.getDefaultLocale()))) {
                localizedValue.addString(ddmFormLayout.getDefaultLocale(), LanguageUtil.get((Locale)ddmFormLayout.getDefaultLocale(), (String)"description"));
            }
            ddmFormLayoutPage.setDescription(localizedValue);
        }
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout).build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    private void _upgradeDecimalField(JSONObject jsonObject) {
        jsonObject.put("dataType", "decimal").put("type", "numeric").put("visibilityExpression", "");
    }

    private String _upgradeDefinition(long companyId, String definition) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)definition);
        jsonObject.put("fields", this._upgradeFields(companyId, jsonObject.getJSONArray("fields")));
        return jsonObject.toString();
    }

    private void _upgradeDocumentLibraryField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "document_library").put("visibilityExpression", "");
    }

    private JSONArray _upgradeFields(long companyId, JSONArray fieldsJSONArray) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        if (fieldsJSONArray != null) {
            for (int i = 0; i < fieldsJSONArray.length(); ++i) {
                JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
                String type = jsonObject.getString("type");
                if (StringUtil.equals((String)type, (String)"ddm-color")) {
                    this._upgradeColorField(jsonObject);
                } else if (StringUtil.equals((String)type, (String)"ddm-date")) {
                    this._upgradeDateField(jsonObject);
                } else if (type.startsWith("ddm-decimal")) {
                    this._upgradeDecimalField(jsonObject);
                } else if (type.startsWith("ddm-documentlibrary")) {
                    this._upgradeDocumentLibraryField(jsonObject);
                } else if (type.startsWith("ddm-geolocation")) {
                    this._upgradeGeolocation(jsonObject);
                } else if (type.startsWith("ddm-image")) {
                    this._upgradeImageField(jsonObject);
                } else if (type.startsWith("ddm-integer")) {
                    this._upgradeIntegerField(jsonObject);
                } else if (type.startsWith("ddm-journal-article")) {
                    this._upgradeJournalArticleField(jsonObject);
                } else if (type.startsWith("ddm-link-to-page")) {
                    this._upgradeLinkToPageField(jsonObject);
                } else if (type.startsWith("ddm-number")) {
                    this._upgradeNumberField(jsonObject);
                } else if (StringUtil.equals((String)type, (String)"ddm-separator")) {
                    this._upgradeSeparatorField(jsonObject);
                } else if (type.startsWith("ddm-text-html")) {
                    this._upgradeHTMLField(jsonObject);
                } else if (type.startsWith("ddm-")) {
                    jsonObject.put("dataType", "string").put("type", type.substring(4));
                } else if (StringUtil.equals((String)type, (String)"text")) {
                    this._upgradeTextField(companyId, jsonObject);
                } else if (StringUtil.equals((String)type, (String)"textarea")) {
                    this._upgradeTextArea(companyId, jsonObject);
                }
                if (jsonObject.has("nestedFields")) {
                    jsonObject.put("nestedFields", this._upgradeFields(companyId, jsonObject.getJSONArray("nestedFields")));
                }
                jsonArray.put(jsonObject);
            }
        }
        return jsonArray;
    }

    private void _upgradeGeolocation(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "geolocation");
    }

    private void _upgradeHTMLField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "rich_text");
    }

    private void _upgradeImageField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "image");
    }

    private void _upgradeIntegerField(JSONObject jsonObject) {
        jsonObject.put("type", "numeric").put("visibilityExpression", "");
    }

    private void _upgradeJournalArticleField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "journal_article");
    }

    private void _upgradeLinkToPageField(JSONObject jsonObject) {
        jsonObject.put("dataType", "string").put("type", "link_to_layout");
    }

    private void _upgradeNumberField(JSONObject jsonObject) {
        jsonObject.put("dataType", "decimal").put("type", "numeric").put("visibilityExpression", "");
    }

    private void _upgradeSeparatorField(JSONObject jsonObject) {
        jsonObject.put("dataType", "").put("type", "separator");
    }

    private void _upgradeStructureDefinition() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select * from DDMStructure where classNameId = ? or classNameId = ? ");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.document.library.kernel.model.DLFileEntryMetadata"));
            ps1.setLong(2, PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = this._upgradeDefinition(rs.getLong("companyId"), rs.getString("definition"));
                    ps2.setString(1, definition);
                    ps2.setLong(2, rs.getLong("structureId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeStructureLayoutDefinition() throws Exception {
        StringBundler sb1 = new StringBundler(11);
        sb1.append("select DDMStructureLayout.definition, ");
        sb1.append("DDMStructureLayout.structureLayoutId, ");
        sb1.append("DDMStructure.structureKey, DDMStructure.classNameId from ");
        sb1.append("DDMStructureLayout inner join DDMStructureVersion on ");
        sb1.append("DDMStructureVersion.structureVersionId = ");
        sb1.append("DDMStructureLayout.structureVersionId inner join ");
        sb1.append("DDMStructure on DDMStructure.structureId = ");
        sb1.append("DDMStructureVersion.structureId and DDMStructure.version ");
        sb1.append("= DDMStructureVersion.version where ");
        sb1.append("DDMStructure.classNameId = ? or DDMStructure.classNameId ");
        sb1.append("= ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureLayout set definition = ?, classNameId = ?, structureLayoutKey = ? where structureLayoutId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.document.library.kernel.model.DLFileEntryMetadata"));
            ps1.setLong(2, PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ps2.setString(1, this._upgradeDDMFormLayoutDefinition(rs.getString("definition")));
                    ps2.setLong(2, rs.getLong("classNameId"));
                    ps2.setString(3, rs.getString("structureKey"));
                    ps2.setLong(4, rs.getLong("structureLayoutId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeStructureVersionDefinition() throws Exception {
        StringBundler sb1 = new StringBundler(6);
        sb1.append("select DDMStructure.structureKey, DDMStructureVersion.* ");
        sb1.append("from DDMStructureVersion inner join DDMStructure on ");
        sb1.append("DDMStructure.structureId = ");
        sb1.append("DDMStructureVersion.structureId where ");
        sb1.append("DDMStructure.classNameId = ? or DDMStructure.classNameId ");
        sb1.append("= ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.document.library.kernel.model.DLFileEntryMetadata"));
            ps1.setLong(2, PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = this._upgradeDefinition(rs.getLong("companyId"), rs.getString("definition"));
                    ps2.setString(1, definition);
                    ps2.setLong(2, rs.getLong("structureVersionId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    private void _upgradeTextArea(long companyId, JSONObject jsonObject) throws Exception {
        jsonObject.put("autocomplete", false).put("dataSourceType", "manual").put("ddmDataProviderInstanceId", "[]").put("ddmDataProviderInstanceOutput", "[]").put("displayStyle", "multiline").put("fieldNamespace", "").put("options", JSONUtil.put((Object)JSONUtil.put((String)"label", (Object)JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)GetterUtil.getString((String)"Option"))).put("value", "Option"))).put("placeholder", JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)"")).put("tooltip", JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)"")).put("type", "text").put("visibilityExpression", "");
    }

    private void _upgradeTextField(long companyId, JSONObject jsonObject) throws Exception {
        jsonObject.put("autocomplete", false).put("dataSourceType", "manual").put("ddmDataProviderInstanceId", "[]").put("ddmDataProviderInstanceOutput", "[]").put("displayStyle", "singleline").put("fieldNamespace", "").put("options", JSONUtil.put((Object)JSONUtil.put((String)"label", (Object)JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)GetterUtil.getString((String)"Option"))).put("value", "Option"))).put("placeholder", JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)"")).put("tooltip", JSONUtil.put((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId), (Object)"")).put("type", "text").put("visibilityExpression", "");
    }
}

