/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.template;

import com.liferay.dynamic.data.mapping.internal.util.ResourceBundleLoaderProvider;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistry;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.language.LanguageResources;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={TemplateHandlerRegistry.class})
public class TemplateHandlerRegistryImpl
implements TemplateHandlerRegistry {
    @Reference
    protected ResourceBundleLoaderProvider resourceBundleLoaderProvider;
    private BundleContext _bundleContext;
    private final Map<Long, TemplateHandler> _classNameIdTemplateHandlers = new ConcurrentHashMap<Long, TemplateHandler>();
    private final Map<String, TemplateHandler> _classNameTemplateHandlers = new ConcurrentHashMap<String, TemplateHandler>();
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private GroupLocalService _groupLocalService;
    private Portal _portal;
    private final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private UserLocalService _userLocalService;

    public long[] getClassNameIds() {
        return ArrayUtil.toLongArray(this._classNameIdTemplateHandlers.keySet());
    }

    public TemplateHandler getTemplateHandler(long classNameId) {
        return this._classNameIdTemplateHandlers.get(classNameId);
    }

    public TemplateHandler getTemplateHandler(String className) {
        return this._classNameTemplateHandlers.get(className);
    }

    public List<TemplateHandler> getTemplateHandlers() {
        return new ArrayList<TemplateHandler>(this._classNameTemplateHandlers.values());
    }

    @Activate
    protected synchronized void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        for (Map.Entry<String, TemplateHandler> entry : this._classNameTemplateHandlers.entrySet()) {
            String className = entry.getKey();
            TemplateHandler templateHandler = entry.getValue();
            this._classNameIdTemplateHandlers.put(this._portal.getClassNameId(className), templateHandler);
            if (this._serviceRegistrations.containsKey(className)) continue;
            this.registerPortalInstanceLifecycleListener(templateHandler);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void addTemplateHandler(TemplateHandler templateHandler) {
        String className = templateHandler.getClassName();
        this._classNameTemplateHandlers.put(className, templateHandler);
        if (this._bundleContext == null) {
            return;
        }
        this._classNameIdTemplateHandlers.put(this._portal.getClassNameId(className), templateHandler);
        this.registerPortalInstanceLifecycleListener(templateHandler);
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._classNameIdTemplateHandlers.clear();
        this._classNameTemplateHandlers.clear();
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
        this._bundleContext = null;
    }

    protected void registerPortalInstanceLifecycleListener(TemplateHandler templateHandler) {
        ServiceRegistration serviceRegistration = this._serviceRegistrations.get(templateHandler.getClassName());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
        TemplateHandlerPortalInstanceLifecycleListener portalInstanceLifecycleListener = new TemplateHandlerPortalInstanceLifecycleListener(templateHandler);
        serviceRegistration = this._bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)portalInstanceLifecycleListener, (Dictionary)new HashMapDictionary());
        this._serviceRegistrations.put(templateHandler.getClassName(), serviceRegistration);
    }

    protected synchronized void removeTemplateHandler(TemplateHandler templateHandler) {
        ServiceRegistration<?> serviceRegistration;
        String className = templateHandler.getClassName();
        this._classNameTemplateHandlers.remove(className);
        if (this._portal != null) {
            this._classNameIdTemplateHandlers.remove(this._portal.getClassNameId(className));
        }
        if ((serviceRegistration = this._serviceRegistrations.remove(className)) != null) {
            serviceRegistration.unregister();
        }
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<DDMTemplate> modelResourcePermission) {
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this._portal = portal;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private class TemplateHandlerPortalInstanceLifecycleListener
    extends BasePortalInstanceLifecycleListener {
        private static final String _PORTLET_DISPLAY_TEMPLATE_CLASS_NAME = "com.liferay.portlet.display.template.PortletDisplayTemplate";
        private final TemplateHandler _templateHandler;

        public void portalInstanceRegistered(Company company) throws Exception {
            long classNameId = TemplateHandlerRegistryImpl.this._portal.getClassNameId(this._templateHandler.getClassName());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGuestPermissions(true);
            Group group = TemplateHandlerRegistryImpl.this._groupLocalService.getCompanyGroup(company.getCompanyId());
            serviceContext.setScopeGroupId(group.getGroupId());
            long userId = TemplateHandlerRegistryImpl.this._userLocalService.getDefaultUserId(company.getCompanyId());
            serviceContext.setUserId(userId);
            List templateElements = this._templateHandler.getDefaultTemplateElements();
            for (Element templateElement : templateElements) {
                String templateKey = templateElement.elementText("template-key");
                DDMTemplate ddmTemplate = TemplateHandlerRegistryImpl.this._ddmTemplateLocalService.fetchTemplate(group.getGroupId(), classNameId, templateKey);
                if (ddmTemplate != null && (ddmTemplate.getUserId() != userId || ddmTemplate.getVersionUserId() != userId)) continue;
                Class<?> clazz = this._templateHandler.getClass();
                String scriptFileName = templateElement.elementText("script-file");
                String script = StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)scriptFileName);
                if (ddmTemplate != null && StringUtil.equals((String)script, (String)ddmTemplate.getScript())) continue;
                Object resourceBundleLoader = null;
                Bundle bundle = FrameworkUtil.getBundle(clazz);
                resourceBundleLoader = bundle != null ? TemplateHandlerRegistryImpl.this.resourceBundleLoaderProvider.getResourceBundleLoader(bundle.getSymbolicName()) : new AggregateResourceBundleLoader(new ResourceBundleLoader[]{ResourceBundleUtil.getResourceBundleLoader((String)"content.Language", (ClassLoader)clazz.getClassLoader()), LanguageResources.RESOURCE_BUNDLE_LOADER});
                Map<Locale, String> nameMap = this.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, group.getGroupId(), templateElement.elementText("name"));
                Map<Locale, String> descriptionMap = this.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, group.getGroupId(), templateElement.elementText("description"));
                String type = templateElement.elementText("type");
                if (type == null) {
                    type = "display";
                }
                String language = templateElement.elementText("language");
                boolean cacheable = GetterUtil.getBoolean((String)templateElement.elementText("cacheable"));
                if (ddmTemplate == null) {
                    TemplateHandlerRegistryImpl.this._ddmTemplateLocalService.addTemplate(userId, group.getGroupId(), classNameId, 0L, TemplateHandlerRegistryImpl.this._portal.getClassNameId(_PORTLET_DISPLAY_TEMPLATE_CLASS_NAME), templateKey, nameMap, descriptionMap, type, null, language, script, cacheable, false, null, null, serviceContext);
                    continue;
                }
                TemplateHandlerRegistryImpl.this._ddmTemplateLocalService.updateTemplate(userId, ddmTemplate.getTemplateId(), 0L, nameMap, descriptionMap, type, null, language, script, cacheable, false, null, null, serviceContext);
            }
        }

        public void portalInstanceUnregistered(Company company) throws Exception {
        }

        protected Map<Locale, String> getLocalizationMap(ResourceBundleLoader resourceBundleLoader, long groupId, String key) {
            HashMap<Locale, String> map = new HashMap<Locale, String>();
            for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
                ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
                map.put(locale, LanguageUtil.get((ResourceBundle)resourceBundle, (String)key));
            }
            return map;
        }

        private TemplateHandlerPortalInstanceLifecycleListener(TemplateHandler templateHandler) {
            this._templateHandler = templateHandler;
        }
    }
}

