/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.notification;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.soy.data.SoyDataFactory;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormEmailNotificationSender.class})
public class DDMFormEmailNotificationSender {
    private static final String _NAMESPACE = "form.form_entry";
    private static final String _TEMPLATE_PATH = "/META-INF/resources/notification/form_entry_add_body.soy";
    private static final Log _log = LogFactoryUtil.getLog(DDMFormEmailNotificationSender.class);
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private GroupLocalService _groupLocalService;
    private MailService _mailService;
    @Reference
    private Portal _portal;
    @Reference
    private SoyDataFactory _soyDataFactory;
    private UserLocalService _userLocalService;

    public void sendEmailNotification(ServiceContext serviceContext, DDMFormInstanceRecord ddmFormInstanceRecord) {
        try {
            MailMessage mailMessage = this.createMailMessage(serviceContext.getRequest(), ddmFormInstanceRecord);
            this._mailService.sendEmail(mailMessage);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to send form email", (Throwable)exception);
        }
    }

    protected MailMessage createMailMessage(HttpServletRequest httpServletRequest, DDMFormInstanceRecord ddmFormInstanceRecord) throws Exception {
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
        InternetAddress fromInternetAddress = new InternetAddress(this.getEmailFromAddress(ddmFormInstance), this.getEmailFromName(ddmFormInstance));
        String subject = this.getEmailSubject(ddmFormInstance);
        String body = this.getEmailBody(httpServletRequest, ddmFormInstance, ddmFormInstanceRecord);
        MailMessage mailMessage = new MailMessage(fromInternetAddress, subject, body, true);
        InternetAddress[] toAddresses = InternetAddress.parse((String)this.getEmailToAddress(ddmFormInstance));
        mailMessage.setTo(toAddresses);
        return mailMessage;
    }

    protected Template createTemplate(HttpServletRequest httpServletRequest, DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        Template template = TemplateManagerUtil.getTemplate((String)"soy", (TemplateResource)this.getTemplateResource(_TEMPLATE_PATH), (boolean)false);
        this.populateParameters(template, httpServletRequest, ddmFormInstance, ddmFormInstanceRecord);
        return template;
    }

    protected DDMForm getDDMForm(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        return ddmStructure.getDDMForm();
    }

    protected Map<String, List<DDMFormFieldValue>> getDDMFormFieldValuesMap(DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        DDMFormValues ddmFormValues = ddmFormInstanceRecord.getDDMFormValues();
        return ddmFormValues.getDDMFormFieldValuesMap();
    }

    protected DDMFormLayout getDDMFormLayout(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        return ddmStructure.getDDMFormLayout();
    }

    protected String getEmailBody(HttpServletRequest httpServletRequest, DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        Template template = this.createTemplate(httpServletRequest, ddmFormInstance, ddmFormInstanceRecord);
        return this.render(template);
    }

    protected String getEmailFromAddress(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMFormInstanceSettings formInstancetings = ddmFormInstance.getSettingsModel();
        String defaultEmailFromAddress = PrefsPropsUtil.getString((long)ddmFormInstance.getCompanyId(), (String)"admin.email.from.address");
        return GetterUtil.getString((String)formInstancetings.emailFromAddress(), (String)defaultEmailFromAddress);
    }

    protected String getEmailFromName(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMFormInstanceSettings formInstancetings = ddmFormInstance.getSettingsModel();
        String defaultEmailFromName = PrefsPropsUtil.getString((long)ddmFormInstance.getCompanyId(), (String)"admin.email.from.name");
        return GetterUtil.getString((String)formInstancetings.emailFromName(), (String)defaultEmailFromName);
    }

    protected String getEmailSubject(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMFormInstanceSettings formInstancetings = ddmFormInstance.getSettingsModel();
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        Locale locale = ddmForm.getDefaultLocale();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        String defaultEmailSubject = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"new-x-form-submitted", (Object)ddmFormInstance.getName(locale), (boolean)false);
        return GetterUtil.getString((String)formInstancetings.emailSubject(), (String)defaultEmailSubject);
    }

    protected String getEmailToAddress(DDMFormInstance ddmFormInstance) throws PortalException {
        String defaultEmailToAddress = "";
        DDMFormInstanceSettings formInstancetings = ddmFormInstance.getSettingsModel();
        User user = this._userLocalService.fetchUser(ddmFormInstance.getUserId());
        if (user != null) {
            defaultEmailToAddress = user.getEmailAddress();
        }
        return GetterUtil.getString((String)formInstancetings.emailToAddress(), (String)defaultEmailToAddress);
    }

    protected Map<String, Object> getField(List<DDMFormFieldValue> ddmFormFieldValues, Locale locale) {
        String labelString = null;
        StringBundler sb = new StringBundler(ddmFormFieldValues.size() * 2 - 1);
        for (int i = 0; i < ddmFormFieldValues.size(); ++i) {
            DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValues.get(i);
            if (labelString == null) {
                DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
                LocalizedValue label = ddmFormField.getLabel();
                labelString = label.getString(locale);
                if (ddmFormField.isRequired()) {
                    labelString = labelString.concat("*");
                }
            }
            sb.append(this.renderDDMFormFieldValue(ddmFormFieldValue, locale));
            if (i >= ddmFormFieldValues.size() - 1) continue;
            sb.append(", ");
        }
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("label", labelString);
        fieldMap.put("value", this._soyDataFactory.createSoyRawData(sb.toString()));
        return fieldMap;
    }

    protected List<String> getFieldNames(DDMFormLayoutPage ddmFormLayoutPage) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                fieldNames.addAll(ddmFormLayoutColumn.getDDMFormFieldNames());
            }
        }
        return fieldNames;
    }

    protected List<Object> getFields(List<String> fieldNames, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, Locale locale) {
        ArrayList<Object> fields = new ArrayList<Object>();
        for (String fieldName : fieldNames) {
            List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(fieldName);
            if (ddmFormFieldValues == null) continue;
            Map<String, Object> field = this.getField(ddmFormFieldValues, locale);
            fields.add(field);
        }
        return fields;
    }

    protected Locale getLocale(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMForm ddmForm = this.getDDMForm(ddmFormInstance);
        return ddmForm.getDefaultLocale();
    }

    protected Map<String, Object> getPage(DDMFormLayoutPage ddmFormLayoutPage, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, Locale locale) {
        return HashMapBuilder.put((Object)"fields", this.getFields(this.getFieldNames(ddmFormLayoutPage), ddmFormFieldValuesMap, locale)).put((Object)"title", () -> {
            LocalizedValue title = ddmFormLayoutPage.getTitle();
            return title.getString(locale);
        }).build();
    }

    protected List<Object> getPages(DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        ArrayList<Object> pages = new ArrayList<Object>();
        DDMFormLayout ddmFormLayout = this.getDDMFormLayout(ddmFormInstance);
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            Map<String, Object> page = this.getPage(ddmFormLayoutPage, this.getDDMFormFieldValuesMap(ddmFormInstanceRecord), this.getLocale(ddmFormInstance));
            pages.add(page);
        }
        return pages;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
    }

    protected String getSiteName(long groupId, Locale locale) {
        Group siteGroup = this._groupLocalService.fetchGroup(groupId);
        if (siteGroup != null) {
            return siteGroup.getName(locale);
        }
        return "";
    }

    protected TemplateResource getTemplateResource(String templatePath) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL templateURL = classLoader.getResource(templatePath);
        return new URLTemplateResource(templateURL.getPath(), templateURL);
    }

    protected ThemeDisplay getThemeDisplay(HttpServletRequest httpServletRequest) {
        return (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    protected String getUserName(DDMFormInstanceRecord ddmFormInstanceRecord, Locale locale) {
        String userName = ddmFormInstanceRecord.getUserName();
        if (Validator.isNotNull((String)userName)) {
            return userName;
        }
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)"someone");
    }

    protected String getViewFormEntriesURL(DDMFormInstance ddmFormInstance, ThemeDisplay themeDisplay) throws PortalException {
        String portletNamespace = this._portal.getPortletNamespace("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet");
        HashMap params = HashMapBuilder.put((Object)portletNamespace.concat("mvcPath"), (Object)new String[]{"/admin/view_form_instance_records.jsp"}).put((Object)portletNamespace.concat("formInstanceId"), (Object)new String[]{String.valueOf(ddmFormInstance.getFormInstanceId())}).build();
        return this._portal.getSiteAdminURL(themeDisplay, "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", (Map)params);
    }

    protected String getViewFormURL(DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord, ThemeDisplay themeDisplay) throws PortalException {
        String portletNamespace = this._portal.getPortletNamespace("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet");
        HashMap params = HashMapBuilder.put((Object)portletNamespace.concat("mvcPath"), (Object)new String[]{"/admin/view_form_instance_record.jsp"}).put((Object)portletNamespace.concat("formInstanceRecordId"), (Object)new String[]{String.valueOf(ddmFormInstanceRecord.getFormInstanceRecordId())}).put((Object)portletNamespace.concat("formInstanceId"), (Object)new String[]{String.valueOf(ddmFormInstance.getFormInstanceId())}).build();
        return this._portal.getSiteAdminURL(themeDisplay, "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", (Map)params);
    }

    protected void populateParameters(Template template, HttpServletRequest httpServletRequest, DDMFormInstance ddmFormInstance, DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        Locale locale = this.getLocale(ddmFormInstance);
        template.put((Object)"authorName", (Object)ddmFormInstance.getUserName());
        template.put((Object)"formName", (Object)ddmFormInstance.getName(locale));
        template.put((Object)"pages", this.getPages(ddmFormInstance, ddmFormInstanceRecord));
        template.put((Object)"siteName", (Object)this.getSiteName(ddmFormInstance.getGroupId(), locale));
        template.put((Object)"userName", (Object)this.getUserName(ddmFormInstanceRecord, locale));
        ThemeDisplay themeDisplay = this.getThemeDisplay(httpServletRequest);
        template.put((Object)"viewFormEntriesURL", (Object)this.getViewFormEntriesURL(ddmFormInstance, themeDisplay));
        template.put((Object)"viewFormURL", (Object)this.getViewFormURL(ddmFormInstance, ddmFormInstanceRecord, themeDisplay));
    }

    protected String render(Template template) throws TemplateException {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.put((Object)"namespace", (Object)_NAMESPACE);
        template.processTemplate((Writer)writer);
        return writer.toString();
    }

    protected String renderDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Locale locale) {
        if (ddmFormFieldValue.getValue() == null) {
            return "";
        }
        DDMFormFieldValueRenderer ddmFormFieldValueRenderer = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueRenderer(ddmFormFieldValue.getType());
        return HtmlUtil.unescape((String)ddmFormFieldValueRenderer.render(ddmFormFieldValue, locale));
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setMailService(MailService mailService) {
        this._mailService = mailService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

