/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceRecordServiceBaseImpl;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddm", "json.web.service.context.path=DDMFormInstanceRecord"}, service={AopService.class})
public class DDMFormInstanceRecordServiceImpl
extends DDMFormInstanceRecordServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstance)")
    private ModelResourcePermission<DDMFormInstance> _ddmFormInstanceModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord)")
    private ModelResourcePermission<DDMFormInstanceRecord> _ddmFormInstanceRecordModelResourcePermission;

    public DDMFormInstanceRecord addFormInstanceRecord(long groupId, long ddmFormInstanceId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        this._ddmFormInstanceModelResourcePermission.check(this.getPermissionChecker(), ddmFormInstanceId, "ADD_FORM_INSTANCE_RECORD");
        return this.ddmFormInstanceRecordLocalService.addFormInstanceRecord(this.getGuestOrUserId(), groupId, ddmFormInstanceId, ddmFormValues, serviceContext);
    }

    public void deleteFormInstanceRecord(long ddmFormInstanceRecordId) throws PortalException {
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), ddmFormInstanceRecordId, "DELETE");
        this.ddmFormInstanceRecordLocalService.deleteFormInstanceRecord(ddmFormInstanceRecordId);
    }

    public DDMFormInstanceRecord getFormInstanceRecord(long ddmFormInstanceRecordId) throws PortalException {
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), ddmFormInstanceRecordId, "VIEW");
        return this.ddmFormInstanceRecordLocalService.getFormInstanceRecord(ddmFormInstanceRecordId);
    }

    public List<DDMFormInstanceRecord> getFormInstanceRecords(long ddmFormInstanceId) throws PortalException {
        this._ddmFormInstanceModelResourcePermission.contains(this.getPermissionChecker(), ddmFormInstanceId, "VIEW");
        return this.ddmFormInstanceRecordLocalService.getFormInstanceRecords(ddmFormInstanceId);
    }

    public List<DDMFormInstanceRecord> getFormInstanceRecords(long ddmFormInstanceId, int status, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) throws PortalException {
        this._ddmFormInstanceModelResourcePermission.contains(this.getPermissionChecker(), ddmFormInstanceId, "VIEW");
        return this.ddmFormInstanceRecordLocalService.getFormInstanceRecords(ddmFormInstanceId, status, start, end, orderByComparator);
    }

    public int getFormInstanceRecordsCount(long ddmFormInstanceId) throws PortalException {
        this._ddmFormInstanceModelResourcePermission.contains(this.getPermissionChecker(), ddmFormInstanceId, "VIEW");
        return this.ddmFormInstanceRecordLocalService.getFormInstanceRecordsCount(ddmFormInstanceId);
    }

    public void revertFormInstanceRecord(long ddmFormInstanceRecordId, String version, ServiceContext serviceContext) throws PortalException {
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordLocalService.getFormInstanceRecord(ddmFormInstanceRecordId);
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmFormInstanceRecord, "UPDATE");
        this.ddmFormInstanceRecordLocalService.revertFormInstanceRecord(this.getGuestOrUserId(), ddmFormInstanceRecordId, version, serviceContext);
    }

    public DDMFormInstanceRecord updateFormInstanceRecord(long ddmFormInstanceRecordId, boolean majorVersion, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordLocalService.getFormInstanceRecord(ddmFormInstanceRecordId);
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmFormInstanceRecord, "UPDATE");
        return this.ddmFormInstanceRecordLocalService.updateFormInstanceRecord(this.getUserId(), ddmFormInstanceRecordId, majorVersion, ddmFormValues, serviceContext);
    }
}

