/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_0;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;

public class UpgradeDDMStructure
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;

    public UpgradeDDMStructure(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
    }

    protected void doUpgrade() throws Exception {
        this.upgradeDDMStructureDefinition();
        this.upgradeDDMStructureVersionDefinition();
    }

    protected String updateDefinition(String definition) {
        DDMFormDeserializerDeserializeRequest.Builder deserializerBuilder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)definition);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._ddmFormDeserializer.deserialize(deserializerBuilder.build());
        DDMForm ddmForm = ddmFormDeserializerDeserializeResponse.getDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        List ddmFormRules = ddmForm.getDDMFormRules();
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            String visibilityExpression = ddmFormField.getVisibilityExpression();
            if (Validator.isNull((String)visibilityExpression)) continue;
            DDMFormRule ddmFormRule = new DDMFormRule(visibilityExpression, new String[]{"setVisible('" + ddmFormField.getName() + "', true)"});
            ddmFormRules.add(ddmFormRule);
            ddmFormField.setVisibilityExpression("");
        }
        ddmForm.setDDMFormRules(ddmFormRules);
        DDMFormSerializerSerializeRequest.Builder serializerBuilder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(serializerBuilder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }

    protected void upgradeDDMStructureDefinition() throws Exception {
        StringBundler sb = new StringBundler(2);
        sb.append("select DDMStructure.definition, DDMStructure.structureId ");
        sb.append("from DDMStructure");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String definition = rs.getString(1);
                long structureId = rs.getLong(2);
                String newDefinition = this.updateDefinition(definition);
                ps2.setString(1, newDefinition);
                ps2.setLong(2, structureId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void upgradeDDMStructureVersionDefinition() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("select DDMStructureVersion.definition, ");
        sb.append("DDMStructureVersion.structureVersionId from ");
        sb.append("DDMStructureVersion");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String definition = rs.getString(1);
                long structureVersionId = rs.getLong(2);
                String newDefinition = this.updateDefinition(definition);
                ps2.setString(1, newDefinition);
                ps2.setLong(2, structureVersionId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

