/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveResponse;
import com.liferay.portal.kernel.exception.PortalException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.storage.adapter.type=default", "service.ranking:Integer=100"}, service={DDMStorageAdapter.class})
public class DefaultDDMStorageAdapter
implements DDMStorageAdapter {
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private DDMFieldLocalService _ddmFieldLocalService;

    public DDMStorageAdapterDeleteResponse delete(DDMStorageAdapterDeleteRequest ddmStorageAdapterDeleteRequest) {
        this._ddmFieldLocalService.deleteDDMFormValues(ddmStorageAdapterDeleteRequest.getPrimaryKey());
        return DDMStorageAdapterDeleteResponse.Builder.newBuilder().build();
    }

    public DDMStorageAdapterGetResponse get(DDMStorageAdapterGetRequest ddmStorageAdapterGetRequest) {
        return DDMStorageAdapterGetResponse.Builder.newBuilder((DDMFormValues)this._ddmFieldLocalService.getDDMFormValues(ddmStorageAdapterGetRequest.getDDMForm(), ddmStorageAdapterGetRequest.getPrimaryKey())).build();
    }

    public DDMStorageAdapterSaveResponse save(DDMStorageAdapterSaveRequest ddmStorageAdapterSaveRequest) throws StorageException {
        long primaryKey = ddmStorageAdapterSaveRequest.getPrimaryKey();
        if (ddmStorageAdapterSaveRequest.isInsert()) {
            primaryKey = this._counterLocalService.increment();
        }
        try {
            this._ddmFieldLocalService.updateDDMFormValues(ddmStorageAdapterSaveRequest.getStructureId(), primaryKey, ddmStorageAdapterSaveRequest.getDDMFormValues());
        }
        catch (PortalException portalException) {
            throw new StorageException((Throwable)portalException);
        }
        return DDMStorageAdapterSaveResponse.Builder.newBuilder((long)primaryKey).build();
    }
}

