/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_6;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DDMDataProviderInstanceUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderInstanceUpgradeProcess.class);
    private final Map<Long, Map<String, String>> _ddmDataProviderInstanceOutputParametersInstanceId = new HashMap<Long, Map<String, String>>();
    private final Map<String, Map<String, String>> _ddmDataProviderInstanceOutputParametersUUID = new HashMap<String, Map<String, String>>();
    private final JSONFactory _jsonFactory;
    private final List<Long> _updatedStructureIds = new ArrayList<Long>();
    private final List<Long> _updatedStructureVersionIds = new ArrayList<Long>();

    public DDMDataProviderInstanceUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(2);
        sb.append("update DDMDataProviderInstance set definition = ? where ");
        sb.append("dataProviderInstanceId = ?");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from DDMDataProviderInstance");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                preparedStatement2.setString(1, this._updateDDMDataProviderInstance(resultSet.getLong("dataProviderInstanceId"), resultSet.getString("definition"), resultSet.getString("uuid_")));
                preparedStatement2.setLong(2, resultSet.getLong("dataProviderInstanceId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
            this._updateDDMStructures();
        }
    }

    private long _extractDDMDataProviderInstanceId(String json) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
            return jsonArray.getLong(0);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            return 0L;
        }
    }

    private String _extractDDMDataProviderInstanceOutputName(String json) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
            return jsonArray.getString(0);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            return "";
        }
    }

    private String _updateDDMDataProviderInstance(long ddmDataProviderInstanceId, String definition, String uuid) throws JSONException {
        String instanceId = StringUtil.randomString();
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldValuesJSONArray = definitionJSONObject.getJSONArray("fieldValues");
        for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
            JSONObject fieldValueJSONObject = fieldValuesJSONArray.getJSONObject(i);
            if (!StringUtil.equals((String)fieldValueJSONObject.getString("name"), (String)"outputParameters")) continue;
            String outputParameterId = StringUtil.randomString();
            JSONArray nestedFieldValuesJSONArray = fieldValueJSONObject.getJSONArray("nestedFieldValues");
            this._updateDDMDataProviderInstanceOutputParameters(ddmDataProviderInstanceId, nestedFieldValuesJSONArray, outputParameterId, uuid);
            nestedFieldValuesJSONArray.put(JSONUtil.put((String)"instanceId", (Object)instanceId).put("name", "outputParameterId").put("value", outputParameterId));
        }
        return definitionJSONObject.toString();
    }

    private void _updateDDMDataProviderInstanceOutputParameters(long ddmDataProviderInstanceId, JSONArray fieldValuesJSONArray, String outputParameterId, String uuid) {
        Map outputParameters;
        JSONObject jsonObject;
        Map<String, String> ddmDataProviderInstanceOutputParameterValues = this._ddmDataProviderInstanceOutputParametersInstanceId.get(ddmDataProviderInstanceId);
        if (ddmDataProviderInstanceOutputParameterValues == null) {
            ddmDataProviderInstanceOutputParameterValues = new HashMap<String, String>();
            this._ddmDataProviderInstanceOutputParametersInstanceId.put(ddmDataProviderInstanceId, ddmDataProviderInstanceOutputParameterValues);
            this._ddmDataProviderInstanceOutputParametersUUID.put(uuid, ddmDataProviderInstanceOutputParameterValues);
        }
        if ((jsonObject = (JSONObject)(outputParameters = JSONUtil.toJSONObjectMap((JSONArray)fieldValuesJSONArray, (String)"name")).get("outputParameterName")) != null) {
            ddmDataProviderInstanceOutputParameterValues.put(jsonObject.getString("value"), outputParameterId);
        }
    }

    private boolean _updateDDMDataProviderRules(JSONArray rulesJSONArray) {
        boolean updated = false;
        for (int i = 0; i < rulesJSONArray.length(); ++i) {
            JSONObject ruleJSONObject = rulesJSONArray.getJSONObject(i);
            JSONArray newActionsJSONArray = this._jsonFactory.createJSONArray();
            List actions = JSONUtil.toStringList((JSONArray)ruleJSONObject.getJSONArray("actions"));
            for (String action : actions) {
                if (action.startsWith("call")) {
                    String[] arguments = StringUtil.split((String)action, (String)"', '");
                    String uuid = arguments[0].substring(6);
                    Map<String, String> ddmDataProviderOutputParameters = this._ddmDataProviderInstanceOutputParametersUUID.get(uuid);
                    String actionOutputsString = arguments[2].substring(0, arguments[2].length() - 2);
                    String[] actionOutputs = StringUtil.split((String)actionOutputsString, (char)';');
                    String newActionOutputsString = "";
                    for (String actionOutput : actionOutputs) {
                        String[] actionOutputParts = StringUtil.split((String)actionOutput, (char)'=');
                        newActionOutputsString = StringBundler.concat((Object[])new Object[]{newActionOutputsString, actionOutputParts[0], Character.valueOf('='), ddmDataProviderOutputParameters.get(actionOutputParts[1]), Character.valueOf(';')});
                    }
                    if (newActionOutputsString.length() > 0) {
                        newActionOutputsString = newActionOutputsString.substring(0, newActionOutputsString.length() - 1);
                    }
                    action = StringBundler.concat((String[])new String[]{"call('", uuid, "', '", arguments[1], "', '", newActionOutputsString, "')"});
                    updated = updated || !newActionOutputsString.equals(actionOutputsString);
                }
                newActionsJSONArray.put(action);
            }
            ruleJSONObject.put("actions", newActionsJSONArray);
        }
        return updated;
    }

    private boolean _updateDDMStructure(JSONObject jsonObject) {
        boolean updatedRules = false;
        JSONArray rulesJSONArray = jsonObject.getJSONArray("rules");
        if (rulesJSONArray != null) {
            updatedRules = this._updateDDMDataProviderRules(rulesJSONArray);
        }
        boolean updatedFields = false;
        JSONArray fieldsJSONArray = jsonObject.getJSONArray("fields");
        if (fieldsJSONArray != null) {
            updatedFields = this._updateFieldsWithDataProviderAssigned(fieldsJSONArray);
        }
        return updatedRules || updatedFields;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _updateDDMStructures() throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append("select DDMStructure.structureId, DDMStructure.definition ");
        sb.append("from DDMDataProviderInstanceLink join DDMStructureVersion ");
        sb.append("on DDMStructureVersion.structureId = ");
        sb.append("DDMDataProviderInstanceLink.structureId left join ");
        sb.append("DDMStructure on DDMStructure.structureId = ");
        sb.append("DDMDataProviderInstanceLink.structureId and ");
        sb.append("DDMStructure.version = DDMStructureVersion.version");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement preparedStatement3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                ResultSet resultSet2;
                block72: {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(resultSet.getString(2));
                    boolean updated = this._updateDDMStructure(jsonObject);
                    long structureId = resultSet.getLong(1);
                    if (updated && !this._updatedStructureIds.contains(structureId)) {
                        preparedStatement2.setString(1, jsonObject.toString());
                        preparedStatement2.setLong(2, structureId);
                        preparedStatement2.addBatch();
                        this._updatedStructureIds.add(structureId);
                    }
                    preparedStatement3.setLong(1, structureId);
                    resultSet2 = preparedStatement3.executeQuery();
                    Throwable throwable = null;
                    try {
                        while (resultSet2.next()) {
                            jsonObject = this._jsonFactory.createJSONObject(resultSet2.getString("definition"));
                            updated = this._updateDDMStructure(jsonObject);
                            long structureVersionId = resultSet2.getLong("structureVersionId");
                            if (!updated || this._updatedStructureVersionIds.contains(structureVersionId)) continue;
                            preparedStatement4.setString(1, jsonObject.toString());
                            preparedStatement4.setLong(2, structureVersionId);
                            preparedStatement4.addBatch();
                            this._updatedStructureVersionIds.add(structureVersionId);
                        }
                        if (resultSet2 == null) continue;
                        if (throwable == null) break block72;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (resultSet2 == null) throw throwable3;
                            if (throwable == null) {
                                resultSet2.close();
                                throw throwable3;
                            }
                            try {
                                resultSet2.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        resultSet2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                resultSet2.close();
            }
            preparedStatement2.executeBatch();
            preparedStatement4.executeBatch();
            return;
        }
    }

    private boolean _updateFieldsWithDataProviderAssigned(JSONArray fieldsJSONArray) {
        boolean updated = false;
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            long ddmDataProviderInstanceId;
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            if (!StringUtil.equals((String)fieldJSONObject.getString("dataSourceType"), (String)"[\"data-provider\"]") || !this._ddmDataProviderInstanceOutputParametersInstanceId.containsKey(ddmDataProviderInstanceId = this._extractDDMDataProviderInstanceId(fieldJSONObject.getString("ddmDataProviderInstanceId")))) continue;
            String ddmDataProviderInstanceOutputName = this._extractDDMDataProviderInstanceOutputName(fieldJSONObject.getString("ddmDataProviderInstanceOutput"));
            Map<String, String> ddmDataProviderOutputParameters = this._ddmDataProviderInstanceOutputParametersInstanceId.get(ddmDataProviderInstanceId);
            String outputParameterId = ddmDataProviderOutputParameters.get(ddmDataProviderInstanceOutputName);
            fieldJSONObject.put("ddmDataProviderInstanceOutput", "[\"" + outputParameterId + "\"]");
            updated = true;
        }
        return updated;
    }
}

