/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_1_1;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMStructureLayoutUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.populateFields();
    }

    protected void populateFields() throws Exception {
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select structureLayoutId from DDMStructureLayout where structureLayoutKey is null or structureLayoutKey = ''");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"update DDMStructureLayout set classNameId = ?, ", "structureLayoutKey = ? where structureLayoutId = ", "?"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                preparedStatement2.setLong(1, classNameId);
                preparedStatement2.setString(2, String.valueOf(this.increment()));
                preparedStatement2.setLong(3, resultSet.getLong(1));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void upgradeSchema() throws Exception {
        if (!this.hasColumn("DDMStructureLayout", "classNameId") && !this.hasColumn("DDMStructureLayout", "structureLayoutKey")) {
            this.runSQL("alter table DDMStructureLayout add classNameId LONG");
            this.runSQL("alter table DDMStructureLayout add structureLayoutKey VARCHAR(75) null");
        }
    }
}

