/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.test.util.search;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.DDMFormValuesReader;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.test.util.AssetEntryQueryTestUtil;
import com.liferay.asset.util.AssetHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.test.util.DDMStructureTestUtil;
import com.liferay.dynamic.data.mapping.test.util.DDMTemplateTestUtil;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslatorUtil;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.osgi.util.service.OSGiServiceUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.SearchContextTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class TestOrderHelper {
    private String _dataType;
    private final DDMIndexer _ddmIndexer;
    private final Group _group;
    private String _indexType;
    private String[] _optionValues;
    private boolean _repeatable;
    private final ServiceContext _serviceContext;
    private String[] _sortedValues;
    private String _type;
    private String[] _unsortedValues;

    public void testOrderByDDMBooleanField() throws Exception {
        this.testOrderByDDMField(new String[]{"false", "true", "false", "true"}, new String[]{"false", "false", "true", "true"}, "boolean", "checkbox");
    }

    public void testOrderByDDMBooleanFieldRepeatable() throws Exception {
        this.testOrderByDDMFieldRepeatable(new String[]{"true|true", "false|false", "true|true", "false|false"}, new String[]{"false|false", "false|false", "true|true", "true|true"}, "boolean", "checkbox");
    }

    public void testOrderByDDMDateField() throws Exception {
        this.testOrderByDDMField(new String[]{"20160417192501", "20160417192510", "20160417192503"}, new String[]{"20160417192501", "20160417192503", "20160417192510"}, "date", "ddm-date");
    }

    public void testOrderByDDMIntegerField() throws Exception {
        this.testOrderByDDMField(new String[]{"1", "10", "3", "2"}, new String[]{"1", "2", "3", "10"}, "integer", "ddm-integer");
    }

    public void testOrderByDDMIntegerFieldRepeatable() throws Exception {
        this.testOrderByDDMFieldRepeatable(new String[]{"50", "707|25", "1|99|42"}, new String[]{"1|99|42", "707|25", "50"}, "integer", "ddm-integer");
    }

    public void testOrderByDDMNumberField() throws Exception {
        this.testOrderByDDMField(new String[]{"3", "3.14", "12.34", "2.72", "1.41", "23.45", "20"}, new String[]{"1.41", "2.72", "3", "3.14", "12.34", "20", "23.45"}, "number", "ddm-number");
    }

    public void testOrderByDDMNumberFieldRepeatable() throws Exception {
        this.testOrderByDDMFieldRepeatable(new String[]{"20|12.34", "16.0", "3.14"}, new String[]{"3.14", "20|12.34", "16.0"}, "number", "ddm-number");
    }

    public void testOrderByDDMRadioField() throws Exception {
        this.testOrderByDDMRadioField("text");
    }

    public void testOrderByDDMRadioFieldKeyword() throws Exception {
        this.testOrderByDDMRadioField("keyword");
    }

    public void testOrderByDDMTextField() throws Exception {
        this.testOrderByDDMTextField("text");
    }

    public void testOrderByDDMTextFieldKeyword() throws Exception {
        this.testOrderByDDMTextField("keyword");
    }

    public void testOrderByDDMTextFieldRepeatable() throws Exception {
        this.testOrderByDDMFieldRepeatable(new String[]{"B", "X|Y", "D|A|C|Z"}, new String[]{"D|A|C|Z", "B", "X|Y"}, "string", "text");
    }

    protected static String[] toJsonArrays(String ... strings) {
        String[] jsonArrays = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            jsonArrays[i] = "[\"" + strings[i] + "\"]";
        }
        return jsonArrays;
    }

    protected TestOrderHelper(DDMIndexer ddmIndexer, Group group) throws Exception {
        this._ddmIndexer = ddmIndexer;
        this._group = group;
        this._serviceContext = ServiceContextTestUtil.getServiceContext((long)group.getGroupId());
    }

    protected DDMStructure addDDMStructure() throws Exception {
        DDMForm ddmForm = DDMStructureTestUtil.getSampleDDMForm("name", this._dataType, this._indexType, this._repeatable, this._type, new Locale[]{LocaleUtil.US}, LocaleUtil.US);
        this.setDDMFormFieldOptions(ddmForm);
        return DDMStructureTestUtil.addStructure(this._serviceContext.getScopeGroupId(), this.getSearchableAssetEntryStructureClassName(), ddmForm);
    }

    protected DDMTemplate addDDMTemplate(DDMStructure ddmStructure) throws Exception {
        return DDMTemplateTestUtil.addTemplate(this._serviceContext.getScopeGroupId(), ddmStructure.getStructureId(), this.getClassNameId());
    }

    protected void addSearchableAssetEntries(DDMStructure ddmStructure, DDMTemplate ddmTemplate) throws Exception {
        BaseModel<?> parentBaseModel = this.getSearchableAssetEntryParentBaseModel(this._group, this._serviceContext);
        for (String value : this._unsortedValues) {
            if (!this._repeatable) {
                this.addSearchableAssetEntry(value, parentBaseModel, ddmStructure, ddmTemplate, this._serviceContext);
                continue;
            }
            this.addSearchableAssetEntryRepeatable(StringUtil.split((String)value, (char)'|'), parentBaseModel, ddmStructure, ddmTemplate, this._serviceContext);
        }
    }

    protected abstract BaseModel<?> addSearchableAssetEntry(String var1, BaseModel<?> var2, DDMStructure var3, DDMTemplate var4, ServiceContext var5) throws Exception;

    protected abstract BaseModel<?> addSearchableAssetEntryRepeatable(String[] var1, BaseModel<?> var2, DDMStructure var3, DDMTemplate var4, ServiceContext var5) throws Exception;

    protected void assertSearch(AssetEntryQuery assetEntryQuery) throws Exception {
        Hits hits = this.search(assetEntryQuery);
        Bundle bundle = FrameworkUtil.getBundle(TestOrderHelper.class);
        List assetEntries = (List)OSGiServiceUtil.callService((BundleContext)bundle.getBundleContext(), AssetHelper.class, assetHelper -> assetHelper.getAssetEntries(hits));
        Assert.assertEquals((Object)ArrayUtils.toString((Object)this._sortedValues), (Object)ArrayUtils.toString((Object)this.getValues(assetEntries)));
    }

    protected AssetEntryQuery createAssetEntryQuery(DDMStructure ddmStructure) throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery((long)this._group.getGroupId(), (String[])new String[]{this.getSearchableAssetEntryClassName()});
        String orderByCol1 = this._ddmIndexer.encodeName(ddmStructure.getStructureId(), "name");
        assetEntryQuery.setOrderByCol1(orderByCol1);
        assetEntryQuery.setOrderByType1("asc");
        return assetEntryQuery;
    }

    protected AssetRendererFactory<?> getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getSearchableAssetEntryClassName());
    }

    protected abstract long getClassNameId();

    protected abstract String getSearchableAssetEntryClassName();

    protected abstract BaseModel<?> getSearchableAssetEntryParentBaseModel(Group var1, ServiceContext var2) throws Exception;

    protected abstract String getSearchableAssetEntryStructureClassName();

    protected String getValue(AssetRenderer<?> assetRenderer) throws Exception {
        DDMFormValuesReader ddmFormValuesReader = assetRenderer.getDDMFormValuesReader();
        DDMFormValues ddmFormValues = DDMBeanTranslatorUtil.translate((com.liferay.dynamic.data.mapping.kernel.DDMFormValues)ddmFormValuesReader.getDDMFormValues());
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        return ListUtil.toString((List)((List)ddmFormFieldValuesMap.get("name")), (Accessor)new ValueAccessor(LocaleUtil.getDefault()){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                return value.getString(this.locale);
            }
        }, (String)"|");
    }

    protected String[] getValues(List<AssetEntry> assetEntries) throws Exception {
        AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory();
        String[] values = new String[assetEntries.size()];
        for (int i = 0; i < assetEntries.size(); ++i) {
            AssetEntry assetEntry = assetEntries.get(i);
            values[i] = this.getValue(assetRendererFactory.getAssetRenderer(assetEntry.getClassPK()));
        }
        return values;
    }

    protected Hits search(AssetEntryQuery assetEntryQuery) throws Exception {
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        Bundle bundle = FrameworkUtil.getBundle(TestOrderHelper.class);
        return (Hits)OSGiServiceUtil.callService((BundleContext)bundle.getBundleContext(), AssetHelper.class, assetHelper -> assetHelper.search(searchContext, assetEntryQuery, -1, -1));
    }

    protected void setDDMFormFieldOptions(DDMForm ddmForm) {
        if (!this._type.equals("radio")) {
            return;
        }
        List ddmFormFields = ddmForm.getDDMFormFields();
        DDMFormField ddmFormField = (DDMFormField)ddmFormFields.get(0);
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (String option : this._optionValues) {
            ddmFormFieldOptions.addOptionLabel(option, LocaleUtil.US, option);
        }
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
    }

    protected void testOrderByDDMField() throws Exception {
        DDMStructure ddmStructure = this.addDDMStructure();
        DDMTemplate ddmTemplate = this.addDDMTemplate(ddmStructure);
        this.addSearchableAssetEntries(ddmStructure, ddmTemplate);
        AssetEntryQuery assetEntryQuery = this.createAssetEntryQuery(ddmStructure);
        this.assertSearch(assetEntryQuery);
    }

    protected void testOrderByDDMField(String[] unsortedValues, String[] sortedValues, String dataType, String type) throws Exception {
        this.testOrderByDDMField(unsortedValues, sortedValues, dataType, "text", type);
    }

    protected void testOrderByDDMField(String[] unsortedValues, String[] sortedValues, String dataType, String indexType, String type) throws Exception {
        this._unsortedValues = unsortedValues;
        this._sortedValues = sortedValues;
        this._dataType = dataType;
        this._indexType = indexType;
        this._type = type;
        this._repeatable = false;
        this.testOrderByDDMField();
    }

    protected void testOrderByDDMFieldRepeatable(String[] unsortedValues, String[] sortedValues, String dataType, String type) throws Exception {
        this._unsortedValues = unsortedValues;
        this._sortedValues = sortedValues;
        this._dataType = dataType;
        this._indexType = "text";
        this._type = type;
        this._repeatable = true;
        this.testOrderByDDMField();
    }

    protected void testOrderByDDMRadioField(String indexType) throws Exception {
        this.testOrderByDDMRadioField(new String[]{"a", "D", "c", "B"}, new String[]{"a", "B", "c", "D"}, "string", indexType, "radio");
    }

    protected void testOrderByDDMRadioField(String[] unsortedValues, String[] sortedValues, String dataType, String indexType, String type) throws Exception {
        this._unsortedValues = unsortedValues;
        this._sortedValues = sortedValues;
        this._dataType = dataType;
        this._indexType = indexType;
        this._type = type;
        this._optionValues = unsortedValues;
        this._repeatable = false;
        this.testOrderByDDMField();
    }

    protected void testOrderByDDMTextField(String indexType) throws Exception {
        String dummyText = "";
        if (Objects.equals(indexType, "text")) {
            while (dummyText.length() < 40000) {
                dummyText = dummyText + " word";
            }
        }
        this.testOrderByDDMField(new String[]{"a" + dummyText, "D" + dummyText, "c" + dummyText, "B" + dummyText}, new String[]{"a" + dummyText, "B" + dummyText, "c" + dummyText, "D" + dummyText}, "string", indexType, "text");
    }
}

