/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.test.util;

import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.test.util.DDMFormValuesTestUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.stream.Stream;

public class DDMFormLayoutTestUtil {
    public static DDMFormLayout createDDMFormLayout(DDMFormLayoutPage ... ddmFormLayoutPages) {
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        Stream.of(ddmFormLayoutPages).forEach(arg_0 -> ((DDMFormLayout)ddmFormLayout).addDDMFormLayoutPage(arg_0));
        return ddmFormLayout;
    }

    public static DDMFormLayout createDDMFormLayout(String paginationMode, DDMFormLayoutPage ... ddmFormLayoutPages) {
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        ddmFormLayout.setPaginationMode(paginationMode);
        Stream.of(ddmFormLayoutPages).forEach(arg_0 -> ((DDMFormLayout)ddmFormLayout).addDDMFormLayoutPage(arg_0));
        return ddmFormLayout;
    }

    public static DDMFormLayout createDDMFormLayout(String pageDescription, String pageTitle, String[] ddmFormFieldNames) {
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        ddmFormLayout.addDDMFormLayoutPage(DDMFormLayoutTestUtil.createDDMFormLayoutPage(pageDescription, pageTitle, ddmFormFieldNames));
        return ddmFormLayout;
    }

    public static DDMFormLayoutColumn createDDMFormLayoutColumn(String ... ddmFormFieldNames) {
        DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn();
        ddmFormLayoutColumn.setDDMFormFieldNames(ListUtil.fromArray((Object[])ddmFormFieldNames));
        ddmFormLayoutColumn.setSize(12);
        return ddmFormLayoutColumn;
    }

    public static DDMFormLayoutColumn[] createDDMFormLayoutColumns(String ... ddmFormFieldNames) {
        return (DDMFormLayoutColumn[])Stream.of(ddmFormFieldNames).map(ddmFormFieldName -> {
            DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn();
            ddmFormLayoutColumn.setDDMFormFieldNames(ListUtil.fromArray((Object[])ddmFormFieldNames));
            ddmFormLayoutColumn.setSize(12 / ddmFormFieldNames.length);
            return ddmFormLayoutColumn;
        }).toArray(DDMFormLayoutColumn[]::new);
    }

    public static DDMFormLayoutPage createDDMFormLayoutPage(String ... ddmFormFieldNames) {
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        ddmFormLayoutPage.addDDMFormLayoutRow(DDMFormLayoutTestUtil.createDDMFormLayoutRow(ddmFormFieldNames));
        return ddmFormLayoutPage;
    }

    public static DDMFormLayoutPage createDDMFormLayoutPage(String description, String title, DDMFormLayoutColumn ... ddmFormLayoutColumns) {
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        ddmFormLayoutPage.addDDMFormLayoutRow(DDMFormLayoutTestUtil.createDDMFormLayoutRow(ddmFormLayoutColumns));
        ddmFormLayoutPage.setDescription(DDMFormValuesTestUtil.createLocalizedValue(description, LocaleUtil.US));
        ddmFormLayoutPage.setTitle(DDMFormValuesTestUtil.createLocalizedValue(title, LocaleUtil.US));
        return ddmFormLayoutPage;
    }

    public static DDMFormLayoutPage createDDMFormLayoutPage(String description, String title, DDMFormLayoutRow ... ddmFormLayoutRows) {
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        Stream.of(ddmFormLayoutRows).forEach(arg_0 -> ((DDMFormLayoutPage)ddmFormLayoutPage).addDDMFormLayoutRow(arg_0));
        ddmFormLayoutPage.setDescription(DDMFormValuesTestUtil.createLocalizedValue(description, LocaleUtil.US));
        ddmFormLayoutPage.setTitle(DDMFormValuesTestUtil.createLocalizedValue(title, LocaleUtil.US));
        return ddmFormLayoutPage;
    }

    public static DDMFormLayoutPage createDDMFormLayoutPage(String description, String title, String[] ddmFormFieldNames) {
        return DDMFormLayoutTestUtil.createDDMFormLayoutPage(description, title, DDMFormLayoutTestUtil.createDDMFormLayoutColumn(ddmFormFieldNames));
    }

    public static DDMFormLayoutRow createDDMFormLayoutRow(DDMFormLayoutColumn ... ddmFormLayoutColumns) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        Stream.of(ddmFormLayoutColumns).forEach(arg_0 -> ((DDMFormLayoutRow)ddmFormLayoutRow).addDDMFormLayoutColumn(arg_0));
        return ddmFormLayoutRow;
    }

    public static DDMFormLayoutRow createDDMFormLayoutRow(String ... ddmFormFieldNames) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        ddmFormLayoutRow.addDDMFormLayoutColumn(DDMFormLayoutTestUtil.createDDMFormLayoutColumn(ddmFormFieldNames));
        return ddmFormLayoutRow;
    }
}

