/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.uad.exporter;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.uad.exporter.BaseDDMFormInstanceRecordUADExporter;
import com.liferay.dynamic.data.mapping.uad.util.DDMUADUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.user.associated.data.exporter.UADExporter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(immediate=true, service={UADExporter.class})
public class DDMFormInstanceRecordUADExporter
extends BaseDDMFormInstanceRecordUADExporter {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordUADExporter.class);
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _ddmFormValuesSerializer;

    @Override
    protected String toXmlString(DDMFormInstanceRecord ddmFormInstanceRecord) {
        StringBundler sb = new StringBundler(7);
        sb.append(StringUtil.removeSubstring((String)super.toXmlString(ddmFormInstanceRecord), (String)"</model>"));
        sb.append("<column><column-name>");
        sb.append("formInstanceName</column-name><column-value><![CDATA[");
        sb.append(this._getFormInstanceName(ddmFormInstanceRecord));
        sb.append("]]></column-value></column>");
        sb.append(this._getFieldValuesXMLString(ddmFormInstanceRecord));
        sb.append("</model>");
        return sb.toString();
    }

    private String _getFieldValuesXMLString(DDMFormInstanceRecord ddmFormInstanceRecord) {
        try {
            StringBundler sb = new StringBundler(10);
            sb.append("<column><model><model-name>");
            sb.append("com.liferay.dynamic.data.mapping.model.DDMContent");
            sb.append("</model-name>");
            DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._ddmFormValuesSerializer.serialize(DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormInstanceRecord.getDDMFormValues()).build());
            JSONObject dataJSONObject = JSONFactoryUtil.createJSONObject((String)ddmFormValuesSerializerSerializeResponse.getContent());
            JSONArray fieldValuesJSONArray = dataJSONObject.getJSONArray("fieldValues");
            fieldValuesJSONArray.forEach(fieldValue -> {
                JSONObject fieldValueJSONObject = (JSONObject)fieldValue;
                sb.append("<column><column-name>");
                sb.append(fieldValueJSONObject.get("name"));
                sb.append("</column-name>");
                sb.append("<column-value><![CDATA[");
                sb.append(fieldValueJSONObject.get("value"));
                sb.append("]]></column-value></column>");
            });
            sb.append("</model></column>");
            return sb.toString();
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get field values from dynamic data mapping form instance record " + ddmFormInstanceRecord.getFormInstanceRecordId()), (Throwable)portalException);
            return null;
        }
    }

    private String _getFormInstanceName(DDMFormInstanceRecord ddmFormInstanceRecord) {
        try {
            DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
            Document document = DDMUADUtil.toDocument(ddmFormInstance.getName());
            Node firstChildNode = document.getFirstChild();
            NodeList nodeList = firstChildNode.getChildNodes();
            Node formInstanceNameNode = nodeList.item(0);
            return formInstanceNameNode.getTextContent();
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get name from dynamic data mapping form instance " + ddmFormInstanceRecord.getFormInstanceId()), (Throwable)portalException);
            return null;
        }
    }
}

