/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Locale;

@ProviderType
public class DDMFormValidationException
extends PortalException {
    public DDMFormValidationException() {
    }

    public DDMFormValidationException(String msg) {
        super(msg);
    }

    public DDMFormValidationException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public DDMFormValidationException(Throwable cause) {
        super(cause);
    }

    public static class MustSetValidVisibilityExpression
    extends DDMFormValidationException {
        private String _fieldName;
        private final String _visibilityExpression;

        public MustSetValidVisibilityExpression(String fieldName, String visibilityExpression) {
            super(String.format("Invalid visibility expression set for field %s: %s", fieldName, visibilityExpression));
            this._fieldName = fieldName;
            this._visibilityExpression = visibilityExpression;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public String getVisibilityExpression() {
            return this._visibilityExpression;
        }
    }

    public static class MustSetValidIndexType
    extends DDMFormValidationException {
        private String _fieldName;

        public MustSetValidIndexType(String fieldName) {
            super(String.format("Invalid index type set for field %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidDefaultLocaleForProperty
    extends DDMFormValidationException {
        private String _fieldName;
        private String _property;

        public MustSetValidDefaultLocaleForProperty(String fieldName, String property) {
            super(String.format("Invalid default locale set for the property '%s' of field name %s", property, fieldName));
            this._fieldName = fieldName;
            this._property = property;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public String getProperty() {
            return this._property;
        }
    }

    public static class MustSetValidCharactersForFieldType
    extends DDMFormValidationException {
        private final String _fieldType;

        public MustSetValidCharactersForFieldType(String fieldType) {
            super(String.format("Invalid characters entered for field type %s", fieldType));
            this._fieldType = fieldType;
        }

        public String getFieldType() {
            return this._fieldType;
        }
    }

    public static class MustSetValidCharactersForFieldName
    extends DDMFormValidationException {
        private String _fieldName;

        public MustSetValidCharactersForFieldName(String fieldName) {
            super(String.format("Invalid characters entered for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidAvailableLocalesForProperty
    extends DDMFormValidationException {
        private String _fieldName;
        private String _property;

        public MustSetValidAvailableLocalesForProperty(String fieldName, String property) {
            super(String.format("Invalid available locales set for the property '%s' of field name %s", property, fieldName));
            this._fieldName = fieldName;
            this._property = property;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public String getProperty() {
            return this._property;
        }
    }

    public static class MustSetOptionsForField
    extends DDMFormValidationException {
        private String _fieldName;

        public MustSetOptionsForField(String fieldName) {
            super(String.format("At least one option must be set for field %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetFieldType
    extends DDMFormValidationException {
        private String _fieldName;

        public MustSetFieldType(String fieldName) {
            super(String.format("The field type was never set for the DDM form field with the field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetDefaultLocaleAsAvailableLocale
    extends DDMFormValidationException {
        private final Locale _defaultLocale;

        public MustSetDefaultLocaleAsAvailableLocale(Locale defaultLocale) {
            super(String.format("The default locale %s must be set to a valid available locale", defaultLocale));
            this._defaultLocale = defaultLocale;
        }

        public Locale getDefaultLocale() {
            return this._defaultLocale;
        }
    }

    public static class MustSetDefaultLocale
    extends DDMFormValidationException {
        public MustSetDefaultLocale() {
            super("The default locale property was not set for the DDM form");
        }
    }

    public static class MustSetAvailableLocales
    extends DDMFormValidationException {
        public MustSetAvailableLocales() {
            super("The available locales property was not set for the DDM form");
        }
    }

    public static class MustNotDuplicateFieldName
    extends DDMFormValidationException {
        private String _fieldName;

        public MustNotDuplicateFieldName(String fieldName) {
            super(String.format("The field name %s cannot be defined more than once", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }
}

