/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal;

import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class DDMFormLayoutValidatorImpl
implements DDMFormLayoutValidator {
    private static final int _MAX_ROW_SIZE = 12;

    @Override
    public void validate(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        this.validateDDMFormLayoutDefaultLocale(ddmFormLayout);
        this.validateDDMFormFieldNames(ddmFormLayout);
        this.validateDDMFormLayoutPageTitles(ddmFormLayout);
        this.validateDDMFormLayoutRowSizes(ddmFormLayout);
    }

    protected void validateDDMFormLayoutDefaultLocale(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        Locale defaultLocale = ddmFormLayout.getDefaultLocale();
        if (defaultLocale == null) {
            throw new DDMFormLayoutValidationException.MustSetDefaultLocale();
        }
    }

    private void validateDDMFormFieldNames(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        HashSet ddmFormFieldNames = new HashSet();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
                for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                    Set intersectDDMFormFieldNames = SetUtil.intersect(ddmFormFieldNames, (Collection)ddmFormLayoutColumn.getDDMFormFieldNames());
                    if (!intersectDDMFormFieldNames.isEmpty()) {
                        throw new DDMFormLayoutValidationException.MustNotDuplicateFieldName(intersectDDMFormFieldNames);
                    }
                    ddmFormFieldNames.addAll(ddmFormLayoutColumn.getDDMFormFieldNames());
                }
            }
        }
    }

    private void validateDDMFormLayoutPageTitles(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        Locale defaultLocale = ddmFormLayout.getDefaultLocale();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            LocalizedValue title = ddmFormLayoutPage.getTitle();
            if (defaultLocale.equals(title.getDefaultLocale())) continue;
            throw new DDMFormLayoutValidationException.MustSetEqualLocaleForLayoutAndTitle();
        }
    }

    private void validateDDMFormLayoutRowSizes(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
                int rowSize = 0;
                for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                    int columnSize = ddmFormLayoutColumn.getSize();
                    if (columnSize <= 0 || columnSize > 12) {
                        throw new DDMFormLayoutValidationException.InvalidColumnSize();
                    }
                    rowSize += ddmFormLayoutColumn.getSize();
                }
                if (rowSize == 12) continue;
                throw new DDMFormLayoutValidationException.InvalidRowSize();
            }
        }
    }
}

